/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IBalancedDependencyRepresentationExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.INodeAndEdgeRepresentationExtension;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependencyRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public final class RemoveRepresentationFromModelCommand
extends SonargraphCommand {
    private final Representation m_representation;
    private final boolean m_fireRepresentationRemovedEvent;
    private final boolean m_removeSlaveRepresentations;

    public RemoveRepresentationFromModelCommand(ISoftwareSystemProvider provider, Representation representation, boolean fireRepresentationRemovedEvent, boolean removeSlaveRepresentations) {
        super(provider);
        assert (representation != null) : "Parameter 'representation' of method 'RemoveRepresentationFromModelCommand' must not be null";
        assert (representation.isValid()) : "Cannot remove invalid representation: " + representation.getName();
        this.m_representation = representation;
        this.m_fireRepresentationRemovedEvent = fireRepresentationRemovedEvent;
        this.m_removeSlaveRepresentations = removeSlaveRepresentations;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.REMOVE_REPRESENTATION_FROM_MODEL;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        if (this.m_representation instanceof BalancedDependencyRepresentation) {
            this.getController().getSoftwareSystem().getExtension(IBalancedDependencyRepresentationExtension.class).removeRepresentation(this.m_representation, this.m_fireRepresentationRemovedEvent, this.m_removeSlaveRepresentations);
        } else {
            this.getController().getSoftwareSystem().getExtension(INodeAndEdgeRepresentationExtension.class).removeRepresentation(this.m_representation, this.m_fireRepresentationRemovedEvent, this.m_removeSlaveRepresentations);
        }
    }

    @Override
    public Result isEnabled() {
        Result result = new Result();
        if (!this.getController().hasSoftwareSystem()) {
            result.addErrorMessage("System no longer available");
        }
        return result;
    }
}

