/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.EnumSet;

public final class OpenSoftwareSystemCommand
extends AbstractOpenCommand {
    public static final ICommandId ID = CoreCommandId.OPEN_SOFTWARE_SYSTEM;
    private final boolean m_refresh;

    public static IPathValidator getSystemDirectoryValidator(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getPathValidator' must not be null";
        return ((ISoftwareSystemController)provider).getSoftwareSystemDirectoryValidator();
    }

    public OpenSoftwareSystemCommand(ISoftwareSystemProvider provider, AbstractOpenCommand.IOpenInteraction interaction, boolean refresh) {
        super(provider, interaction);
        this.m_refresh = refresh;
    }

    @Override
    public final ICommandId getId() {
        return ID;
    }

    @Override
    public ActivityMode getActivityMode() {
        return this.m_refresh ? ActivityMode.MODAL_CANCELABLE : ActivityMode.MODAL;
    }

    @Override
    public boolean providesProgress() {
        return this.m_refresh;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        SoftwareSystem system;
        EnumSet<ISoftwareSystemProvider.OpenOption> openOptions;
        AbstractOpenCommand.OpenData softwareSystemData;
        AbstractOpenCommand.IOpenInteraction interaction = this.getInteraction();
        if (!interaction.collectOpenData(softwareSystemData = new AbstractOpenCommand.OpenData())) {
            return;
        }
        if (this.getController().hasSoftwareSystem()) {
            CloseSoftwareSystemCommand closeSoftwareSystemCommand = new CloseSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), interaction);
            this.runPrerequisiteCommand(closeSoftwareSystemCommand, workerContext);
            if (closeSoftwareSystemCommand.canceled()) {
                return;
            }
        }
        EnumSet<ISoftwareSystemProvider.OpenOption> enumSet = openOptions = softwareSystemData.getFlags().isEmpty() ? EnumSet.noneOf(ISoftwareSystemProvider.OpenOption.class) : EnumSet.copyOf(softwareSystemData.getFlags());
        if (CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.VIRTUAL_MODELS)) {
            openOptions.add(ISoftwareSystemProvider.OpenOption.SWITCH_TO_DEFAULT_MODEL);
        } else {
            openOptions.remove((Object)ISoftwareSystemProvider.OpenOption.SWITCH_TO_DEFAULT_MODEL);
        }
        if (this.m_refresh) {
            openOptions.add(ISoftwareSystemProvider.OpenOption.REFRESH);
        }
        OperationResult result = this.getController().openSoftwareSystem(workerContext, softwareSystemData.getLocation(), openOptions, softwareSystemData.getListener(), softwareSystemData.getDynamicSystemInfo(), softwareSystemData.getWorkspaceProfileName(), softwareSystemData.getQualityModelFile());
        interaction.processOpenResult(result);
        if (result.isSuccess() && this.getController().hasSoftwareSystem() && (system = this.getController().getSoftwareSystem()).getUniqueExistingChild(Workspace.class).isExternalConfigurationChanged() && interaction.confirmSystemSaveDueToExternalFileChangesOnOpen(false)) {
            interaction.processSaveResultDueToExternalFileChangesOnOpen(this.getController().saveSoftwareSystem(workerContext));
        }
    }
}

