/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.ExtendFocusCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGraphRepresentationExtension;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.List;

public final class ExtendGraphFocusCommand
extends ExtendFocusCommand<GraphRepresentation> {
    private final boolean m_onlyVisible;

    public ExtendGraphFocusCommand(ISoftwareSystemProvider provider, GraphRepresentation currentRepresentation, List<Element> elementsToFocus, boolean onlyVisible) {
        super(provider, currentRepresentation, elementsToFocus);
        this.m_onlyVisible = onlyVisible;
    }

    @Override
    public ICommandId getId() {
        if (this.m_onlyVisible) {
            return CoreCommandId.EXTEND_GRAPH_FOCUS_WITH_ONLY_VISIBLE;
        }
        return CoreCommandId.EXTEND_GRAPH_FOCUS;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        GraphRepresentation representation = this.getController().getSoftwareSystem().getExtension(IGraphRepresentationExtension.class).extendFocus(workerContext, (GraphRepresentation)this.getCurrentRepresentation(), this.getSelection(), this.m_onlyVisible);
        this.setRepresentation(representation);
    }
}

