/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.HashMap;
import java.util.Map;

public final class EditSoftwareSystemCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public static ITextValidator getNameValidator(ISoftwareSystemProvider controller) {
        assert (controller != null) : "Parameter 'controller' of method 'getNameValidator' must not be null";
        return ((ISoftwareSystemController)controller).getSoftwareSystemNameValidator();
    }

    public EditSoftwareSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.EDIT_SOFTWARE_SYSTEM;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        SaveSoftwareSystemCommand saveSoftwareSystemCommand;
        EditData data = new EditData();
        if (!((IInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        boolean requiresSave = this.getController().editRequiresSave(data.getName(), data.getDescription());
        if (requiresSave && !((IInteraction)this.getInteraction()).confirmSaveOnEdit()) {
            return;
        }
        if (requiresSave && (saveSoftwareSystemCommand = new SaveSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (SaveSoftwareSystemCommand.ISaveInteraction)this.getInteraction())).isEnabled().isSuccess()) {
            this.runPrerequisiteCommand(saveSoftwareSystemCommand, workerContext);
            if (saveSoftwareSystemCommand.canceled()) {
                return;
            }
        }
        OperationResult result = this.getController().editSoftwareSystem(workerContext, data.getName(), data.getDescription(), data.getMetaData());
        ((IInteraction)this.getInteraction()).processEditResult(result);
    }

    public static final class EditData
    implements ICommandInteractionData {
        private String m_name;
        private String m_description;
        private final Map<String, String> m_metaData = new HashMap<String, String>();

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        public String getDescription() {
            return this.m_description;
        }

        public void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        public void setMetaData(String key, String value) {
            assert (key != null && key.length() > 0) : "Parameter 'key' of method 'setMetaData' must not be empty";
            assert (value != null && value.length() > 0) : "Parameter 'value' of method 'setMetaData' must not be empty";
            this.m_metaData.put(key, value);
        }

        public Map<String, String> getMetaData() {
            return this.m_metaData;
        }
    }

    public static interface IInteraction
    extends SaveSoftwareSystemCommand.ISaveInteraction {
        public boolean collect(EditData var1);

        public boolean confirmSaveOnEdit();

        public void processEditResult(OperationResult var1);
    }
}

