/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IVirtualModelExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.List;

public final class DeleteModifiableModelCommand
extends SoftwareSystemBasedCommand<IDeleteModifiableModelInteraction> {
    public DeleteModifiableModelCommand(ISoftwareSystemProvider provider, IDeleteModifiableModelInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_MODIFIABLE_MODEL;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        DeleteModifiableModelData data = new DeleteModifiableModelData();
        if (!((IDeleteModifiableModelInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        VirtualModel currentModel = this.getSoftwareSystem().getCurrentModel();
        ModifiableModel model = data.getModifiableModel();
        assert (model != null) : "Parameter 'model' of method 'internalRun' must not be null";
        StringBuilder question = new StringBuilder();
        List<ModifiableModel> childModels = model.getChildrenRecursively(ModifiableModel.class, new Class[0]);
        if (model.getName().equals(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL)) {
            if (model.existsOnDisk()) {
                question.append("This will delete:");
                question.append("\n '").append(model.getIdentifyingPath()).append("' (modifiable model)");
                if (!childModels.isEmpty()) {
                    for (ModifiableModel nextChildModel : childModels) {
                        question.append("\n '").append(nextChildModel.getIdentifyingPath()).append("' (modifiable child model)");
                    }
                }
                question.append("\n\n");
            }
            question.append("The modifiable model will be reset to the default content.");
            if (childModels.contains(currentModel)) {
                question.append("\nThe modifiable model '").append(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL).append("' will be applied.");
            }
        } else {
            question.append("This will delete:");
            question.append("\n '").append(model.getIdentifyingPath()).append("' (modifiable model)");
            if (!childModels.isEmpty()) {
                for (ModifiableModel nextChildModel : childModels) {
                    question.append("\n '").append(nextChildModel.getIdentifyingPath()).append("' (modifiable child model)");
                }
            }
            if (model == currentModel || childModels.contains(currentModel)) {
                question.append("\n\nThe modifiable model '").append(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL).append("' will be applied.");
            }
        }
        question.append("\n\nThis cannot be undone. Continue?");
        if (!((IDeleteModifiableModelInteraction)this.getInteraction()).confirmDeletion(data.getModifiableModel(), question.toString())) {
            return;
        }
        IVirtualModelExtension extension = this.getController().getSoftwareSystem().getExtension(IVirtualModelExtension.class);
        OperationResult result = extension.deleteModifiableModel(workerContext, data.getModifiableModel());
        ((IDeleteModifiableModelInteraction)this.getInteraction()).processResult(result);
    }

    public static class DeleteModifiableModelData
    implements ICommandInteractionData {
        private ModifiableModel m_modifiableModel;

        public void setModel(ModifiableModel model) {
            assert (model != null) : "Parameter 'model' of method 'setModel' must not be null";
            this.m_modifiableModel = model;
        }

        public ModifiableModel getModifiableModel() {
            return this.m_modifiableModel;
        }
    }

    public static interface IDeleteModifiableModelInteraction
    extends ICommandInteraction {
        public boolean collect(DeleteModifiableModelData var1);

        public boolean confirmDeletion(ModifiableModel var1, String var2);

        public void processResult(OperationResult var1);
    }
}

