/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.CreateRepresentationCommand;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CreateRepresentationFromScratchCommand<T extends NodeAndEdgeRepresentation>
extends CreateRepresentationCommand<T> {
    private final Set<NamedElement> m_mainNodes;
    private final FocusMode m_focusMode;
    private final PresentationMode m_presentationMode;
    private final boolean m_forceExecution;
    private final EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> m_properties;
    private final Set<CoreParserDependencyType> m_parserDependencyTypes;

    public CreateRepresentationFromScratchCommand(ISoftwareSystemProvider controller, Set<NamedElement> mainNodes, FocusMode focusMode, PresentationMode presentationMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, Set<CoreParserDependencyType> parserDependencyTypes, boolean forceExecution) {
        super(controller);
        assert (mainNodes != null) : "Parameter 'mainNodes' of method 'CreateTreeRepresentationFromScratchCommand' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'CreateTreeRepresentationFromScratchCommand' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'CreateTreeRepresentationFromScratchCommand' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'CreateRepresentationFromScratchCommand' must not be null";
        assert (parserDependencyTypes != null) : "Parameter 'parserDependencyTypes' of method 'CreateRepresentationFromScratchCommand' must not be null";
        this.m_mainNodes = mainNodes;
        this.m_focusMode = focusMode;
        this.m_presentationMode = presentationMode;
        this.m_properties = properties;
        this.m_parserDependencyTypes = parserDependencyTypes;
        this.m_forceExecution = forceExecution;
    }

    @Override
    public final ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    public final boolean providesProgress() {
        return false;
    }

    @Override
    public final Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && this.m_mainNodes.isEmpty()) {
            enabled.addErrorMessage("No named elements specified");
        }
        return enabled;
    }

    @Override
    public List<String> getAdditionalExecutionInfo() {
        ArrayList<String> additionalExecutionInfo = new ArrayList<String>();
        additionalExecutionInfo.add("Elements for representation: " + this.getClassesForElements(this.m_mainNodes));
        additionalExecutionInfo.add("Focus mode: " + String.valueOf((Object)this.m_focusMode));
        additionalExecutionInfo.add("Presentation mode: " + String.valueOf((Object)this.m_presentationMode));
        return additionalExecutionInfo;
    }

    public static Set<CoreParserDependencyType> getDefaultDependencyTypesForEdges() {
        return new HashSet<CoreParserDependencyType>(Arrays.asList(CoreParserDependencyType.values()));
    }

    protected final Set<NamedElement> getMainNodes() {
        return this.m_mainNodes;
    }

    protected final FocusMode getFocusMode() {
        return this.m_focusMode;
    }

    protected final PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    protected EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> getProperties() {
        return this.m_properties;
    }

    protected Set<CoreParserDependencyType> getParserDependencyTypes() {
        return this.m_parserDependencyTypes;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this.m_forceExecution) {
            return this == obj;
        }
        return super.equals(obj);
    }

    @Override
    public abstract ICommandId getId();

    @Override
    protected abstract void internalRun(IWorkerContext var1);
}

