/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Collection;
import java.util.Iterator;

public abstract class CreateRepresentationCommand<T extends NodeAndEdgeRepresentation>
extends SonargraphCommand {
    private T m_representation;

    public CreateRepresentationCommand(ISoftwareSystemProvider provider) {
        super(provider);
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.BLOCKING;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public final boolean isUndoable() {
        return false;
    }

    @Override
    public Result isEnabled() {
        Result enabled = new Result();
        if (!this.getController().hasSoftwareSystem()) {
            enabled.addErrorMessage("No software system opened");
        }
        if (this.m_representation != null) {
            enabled.addErrorMessage("Representation already created");
        }
        return enabled;
    }

    public final T getRepresentation() {
        return this.m_representation;
    }

    public final void setRepresentation(T representation) {
        assert (representation != null) : "Parameter 'representation' of method 'setRepresentation' must not be null";
        this.m_representation = representation;
    }

    protected final String getClassesForElements(Collection<NamedElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getClassesForElements' must not be null";
        StringBuilder builder = new StringBuilder();
        Iterator<NamedElement> it = elements.iterator();
        while (it.hasNext()) {
            NamedElement namedElement = it.next();
            builder.append(namedElement.getClass());
            if (!it.hasNext()) continue;
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        return builder.toString();
    }
}

