/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISnapshotExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;

public final class AttachSnapshotCommand
extends SoftwareSystemBasedCommand<IAttachSnapshotInteraction> {
    public AttachSnapshotCommand(ISoftwareSystemProvider provider, IAttachSnapshotInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.ATTACH_SNAPSHOT;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        SnapshotData data = new SnapshotData();
        if (((IAttachSnapshotInteraction)this.getInteraction()).collect(data)) {
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            ISnapshotExtension extension = softwareSystem.getExtension(ISnapshotExtension.class);
            OperationResultWithOutcome<SoftwareSystem> result = extension.loadSnaphot(workerContext, new TFile(data.getFilePath()));
            if (result.isSuccess()) {
                SaveSoftwareSystemCommand saveSoftwareSystemCommand = new SaveSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (SaveSoftwareSystemCommand.ISaveInteraction)this.getInteraction());
                if (saveSoftwareSystemCommand.isEnabled().isSuccess()) {
                    this.runPrerequisiteCommand(saveSoftwareSystemCommand, workerContext);
                    if (saveSoftwareSystemCommand.canceled()) {
                        return;
                    }
                }
                if (softwareSystem.getState() == SoftwareSystemState.MODEL_LOADED) {
                    if (softwareSystem.isClearable() && !((IAttachSnapshotInteraction)this.getInteraction()).confirm("The currently loaded parser model will be discared.\nWorkspace modifying commands will be disabled.\n\nContinue?")) {
                        return;
                    }
                    result.addMessagesFrom(softwareSystem.getExtension(ISoftwareSystemController.class).clear(workerContext));
                }
                if (result.isSuccess()) {
                    result.addMessagesFrom(extension.attachSnapshot(workerContext, (SoftwareSystem)result.getOutcome()));
                }
            }
            ((IAttachSnapshotInteraction)this.getInteraction()).processAttachResult((OperationResult)result);
        }
    }

    public static interface IAttachSnapshotInteraction
    extends SaveSoftwareSystemCommand.ISaveInteraction {
        public boolean collect(SnapshotData var1);

        public boolean confirm(String var1);

        public void processAttachResult(OperationResult var1);
    }

    public static final class SnapshotData
    implements ICommandInteractionData {
        private String m_filePath;

        public void setFilePath(String filePath) {
            assert (filePath != null) : "Parameter 'filePath' of method 'setFilePath' must not be null";
            this.m_filePath = filePath;
        }

        public String getFilePath() {
            assert (this.m_filePath != null) : "'m_filePath' of method 'getFilePath' must not be null";
            return this.m_filePath;
        }
    }
}

