/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.sonargraph.api.Any;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.Map;

public class PluginProgrammingElement
extends ProgrammingElementWithChildren {
    private String m_pluginId;
    private String m_type;
    private String m_imageResourceName;
    private Map<String, Any> m_properties;

    public PluginProgrammingElement(NamedElement parent) {
        super(parent);
    }

    public PluginProgrammingElement(IModelServiceProvider msp, NamedElement parent, String shortName, int lineNumber, String pluginId, String type, String imageResourceName, Map<String, Any> properties) {
        super(msp, parent, shortName, lineNumber);
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'PluginProgrammingElement' must not be empty";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'PluginProgrammingElement' must not be empty";
        assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'PluginProgrammingElement' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'PluginProgrammingElement' must not be null";
        this.m_pluginId = pluginId;
        this.m_type = type;
        this.m_imageResourceName = imageResourceName;
        this.m_properties = new THashMap(properties);
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    @Override
    public final boolean isMember() {
        return false;
    }

    @Override
    public final void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_pluginId);
        writer.writeString(this.m_type);
        writer.writeString(this.m_imageResourceName);
        writer.writeInt(this.m_properties.size());
        for (Map.Entry<String, Any> entry : this.m_properties.entrySet()) {
            writer.writeString(entry.getKey());
            writer.writeAny(entry.getValue());
        }
    }

    @Override
    public final void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_pluginId = reader.readString();
        this.m_type = reader.readString();
        this.m_imageResourceName = reader.readString();
        int entryCount = reader.readInt();
        this.m_properties = new THashMap(entryCount);
        int i = 0;
        while (i < entryCount) {
            String key = reader.readString();
            Any value = reader.readAny();
            this.m_properties.put(key, value);
            ++i;
        }
    }

    @Property
    public final String getPluginId() {
        return this.m_pluginId;
    }

    @Override
    public final String getImageResourceName() {
        return this.m_imageResourceName;
    }

    @Property
    public final String getPluginElementType() {
        return this.m_type;
    }

    @Property
    public final String getPluginInfo() {
        if (this.m_properties.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Any> next : this.m_properties.entrySet()) {
            result.append(StringUtility.capitalize((String)next.getKey())).append(": ").append(next.getValue().toString()).append("\n");
        }
        result.delete(result.length() - 1, result.length());
        return result.toString();
    }

    public final Any getProperty(String property) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'getProperty' must not be empty";
        return this.m_properties.get(property);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitPluginProgrammingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitPluginProgrammingElement(PluginProgrammingElement var1);
    }
}

