/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.ILogicalNamespaceAccess;
import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IProgrammingElementAccess;
import com.hello2morrow.sonargraph.core.api.model.AggregatorImpl;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.api.model.ModuleAccess;
import com.hello2morrow.sonargraph.core.api.model.ProgrammingElementAccess;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.LogicalNamespaces;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import java.util.ArrayList;
import java.util.List;

public class LogicalNamespaceAccess
extends ElementAccess<LogicalNamespace>
implements ILogicalNamespaceAccess {
    public LogicalNamespaceAccess(LogicalNamespace element) {
        super(element);
    }

    public final IModuleAccess getModuleScope() {
        ModuleBasedLogicalNamespaceRoot moduleBasedLogicalNamespaceRoot = ((LogicalNamespace)this.m_element).getParent(ModuleBasedLogicalNamespaceRoot.class, LogicalNamespaces.class);
        if (moduleBasedLogicalNamespaceRoot != null) {
            return (ModuleAccess)this.m_factory.createAccessObject(moduleBasedLogicalNamespaceRoot.getPhysicalElement());
        }
        return null;
    }

    @Override
    public Object getMetricLevel() {
        return ((LogicalNamespace)this.m_element).getMetricLevel();
    }

    public final boolean isSystemScope() {
        return ((LogicalNamespace)this.m_element).getScope() == LogicalNamespaceScope.SYSTEM;
    }

    public final boolean isPart() {
        return ((LogicalNamespace)this.m_element).isPart();
    }

    public final List<IProgrammingElementAccess> getProgrammingElements() {
        ArrayList<IProgrammingElementAccess> result = new ArrayList<IProgrammingElementAccess>();
        for (ProgrammingElement pe : ((LogicalNamespace)this.m_element).getAllProgrammingElements()) {
            result.add((ProgrammingElementAccess)this.m_factory.createAccessObject(pe));
        }
        return result;
    }

    public final Float getAverageComplexityMetric() {
        if (this.isSystemScope()) {
            return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_AVERAGE_COMPLEXITY_SYSTEM);
        }
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_AVERAGE_COMPLEXITY_MODULE);
    }

    public final Float getAbstractnessMetric() {
        if (this.isSystemScope()) {
            return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_ABSTRACTNESS_SYSTEM);
        }
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_ABSTRACTNESS_MODULE);
    }

    public final Integer getNumberOfTypesMetric() {
        if (this.isSystemScope()) {
            return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_TYPES_SYSTEM);
        }
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_TYPES_MODULE);
    }

    public final Float getDistanceMetric() {
        if (this.isSystemScope()) {
            return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_DISTANCE_SYSTEM);
        }
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_DISTANCE_MODULE);
    }

    public final Float getInstabilityMetric() {
        if (this.isSystemScope()) {
            return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_INSTABILITY_SYSYTEM);
        }
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_INSTABILITY_MODULE);
    }

    public final Integer getNumberOfIncomingDependenciesMetric() {
        if (this.isSystemScope()) {
            return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_INCOMING_DEPENDENCIES_SYSTEM);
        }
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_INCOMING_DEPENDENCIES_MODULE);
    }

    public final Integer getNumberOfOutgoingDependenciesMetric() {
        if (this.isSystemScope()) {
            return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_OUTGOING_DEPENDENCIES_SYSTEM);
        }
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_OUTGOING_DEPENDENCIES_MODULE);
    }

    @Override
    public void accept(INamedElementAccess.INamedElementAccessVisitor visitor) {
        if (visitor instanceof ILogicalNamespaceAccess.IVisitor) {
            ((ILogicalNamespaceAccess.IVisitor)visitor).visitLogicalNamespaceAccess((ILogicalNamespaceAccess)this);
        } else {
            super.accept(visitor);
        }
    }

    public List<IAggregatedDependencyAccess> getOutgoingDependenciesFlatRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExternals, boolean excludeExcluded, IDependencyKind ... types) {
        List<ParserDependency> deps = LogicalNamespaceAccess.collectOutgoingDependencies((NamedElement)this.m_element, excludeExternals, excludeExcluded, LogicalNamespace.class, types);
        return LogicalNamespaceAccess.aggregateOutgoingDependencies(this.m_factory, AggregatorImpl.map(aggr), (NamedElement)this.m_element, excludeSelf, deps);
    }

    public List<IAggregatedDependencyAccess> getOutgoingDependenciesFlatRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExternals, IDependencyKind ... types) {
        return this.getOutgoingDependenciesFlatRecursively(aggr, excludeSelf, excludeExternals, true, types);
    }

    public List<IAggregatedDependencyAccess> getOutgoingDependenciesFlatRecursively(Aggregator aggr, boolean excludeSelf, IDependencyKind ... types) {
        return this.getOutgoingDependenciesFlatRecursively(aggr, excludeSelf, false, true, types);
    }

    public List<IAggregatedDependencyAccess> getIncomingDependenciesFlatRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExcluded, IDependencyKind ... types) {
        List<ParserDependency> deps = LogicalNamespaceAccess.collectIncomingDependencies((NamedElement)this.m_element, excludeExcluded, LogicalNamespace.class, types);
        return LogicalNamespaceAccess.aggregateIncomingDependencies(this.m_factory, AggregatorImpl.map(aggr), (NamedElement)this.m_element, excludeSelf, deps);
    }

    public List<IAggregatedDependencyAccess> getIncomingDependenciesFlatRecursively(Aggregator aggr, boolean excludeSelf, IDependencyKind ... types) {
        return this.getIncomingDependenciesFlatRecursively(aggr, excludeSelf, true, types);
    }

    public List<INamedElementAccess> getReferencingElementsFlatRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExcluded, IDependencyKind ... types) {
        List<ParserDependency> deps = LogicalNamespaceAccess.collectIncomingDependencies((NamedElement)this.m_element, excludeExcluded, LogicalNamespace.class, types);
        return LogicalNamespaceAccess.aggregateReferencingElements(this.m_factory, AggregatorImpl.map(aggr), (NamedElement)this.m_element, excludeSelf, deps);
    }

    public List<INamedElementAccess> getReferencingElementsFlatRecursively(Aggregator aggr, boolean excludeSelf, IDependencyKind ... types) {
        return this.getReferencingElementsFlatRecursively(aggr, excludeSelf, true, types);
    }

    public List<INamedElementAccess> getReferencedElementsFlatRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExternals, boolean excludeExcluded, IDependencyKind ... types) {
        List<ParserDependency> deps = LogicalNamespaceAccess.collectOutgoingDependencies((NamedElement)this.m_element, excludeExternals, excludeExcluded, LogicalNamespace.class, types);
        return LogicalNamespaceAccess.aggregateReferencedElements(this.m_factory, AggregatorImpl.map(aggr), (NamedElement)this.m_element, excludeSelf, deps);
    }

    public List<INamedElementAccess> getReferencedElementsFlatRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExternals, IDependencyKind ... types) {
        return this.getReferencedElementsFlatRecursively(aggr, excludeSelf, excludeExternals, true, types);
    }

    public List<INamedElementAccess> getReferencedElementsFlatRecursively(Aggregator aggr, boolean excludeSelf, IDependencyKind ... types) {
        return this.getReferencedElementsFlatRecursively(aggr, excludeSelf, false, true, types);
    }
}

