/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.snapshot;

import com.hello2morrow.sonargraph.core.model.element.IInvisibleElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.persistence.snapshot.INamedElementFactory;
import java.io.IOException;

final class ObsoleteElementFactory
implements INamedElementFactory {
    static ObsoleteElementFactory DEFAULT = new ObsoleteElementFactory("");
    private final String m_schema;

    public ObsoleteElementFactory(String m_schema) {
        this.m_schema = m_schema;
    }

    @Override
    public NamedElement create(NamedElement parent) {
        return new ObsoleteElement(parent);
    }

    private class ObsoleteElement
    extends NamedElementContainer
    implements IInvisibleElement {
        private ObsoleteElement(NamedElement parent) {
            super(parent);
        }

        @Override
        public String getShortName() {
            return "";
        }

        @Override
        public boolean persist(ISnapshotProcessor.Mode mode) {
            return false;
        }

        @Override
        public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
            int i = 0;
            while (i < ObsoleteElementFactory.this.m_schema.length()) {
                char type = ObsoleteElementFactory.this.m_schema.charAt(i);
                switch (type) {
                    case 'S': {
                        reader.readString();
                        break;
                    }
                    default: {
                        assert (false) : "ObsoleteElement: Unexpected type " + type;
                        break;
                    }
                }
                ++i;
            }
        }
    }
}

