/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ArchitectureFilePersistence {
    public ArchitectureFilePersistence(Version version) {
        assert (version != null) : "Parameter 'version' of method 'ArchitectureFilePersistence' must not be null";
    }

    public void load(TFile file, ArchitectureFile architectureFile, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'loadFromFile' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'loadFromFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'loadFromFile' must not be null";
        try {
            String content = FileUtility.getFileContent((TFile)file);
            architectureFile.setContent(content, false);
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)e);
        }
    }

    public String loadFromStream(InputStream stream, OperationResult result) {
        assert (stream != null) : "Parameter 'stream' of method 'loadFromStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'loadFromStream' must not be null";
        try {
            return FileUtility.getFileContent((InputStream)stream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)ex);
            return null;
        }
    }

    public void save(ArchitectureFile architectureFile, OutputStream stream, OperationResult result) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'storeToStream' must not be null";
        assert (stream != null) : "Parameter 'stream' of method 'storeToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'storeToStream' must not be null";
        try {
            FileUtility.writeFileContent((String)architectureFile.getContent(), (OutputStream)stream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    public OperationResult save(ArchitectureFile architectureFile, TFile file) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'save' must not be null";
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        OperationResult result = new OperationResult("Save Architecture File");
        try {
            FileUtility.writeFileContent((String)architectureFile.getContent(), (TFile)file);
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)e);
        }
        return result;
    }
}

