/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapValueSource;
import java.util.EnumSet;

public final class IssueCollectorValueSource
extends TreeMapValueSource {
    private final EnumSet<ResolutionMode> m_resolutionModes = EnumSet.of(ResolutionMode.NONE, ResolutionMode.TASK);
    private final EnumSet<Severity> m_severities = EnumSet.of(Severity.ERROR, Severity.WARNING);

    public void clear() {
        this.m_resolutionModes.clear();
        this.m_severities.clear();
    }

    @Override
    IssueCollectorValueSource copy() {
        IssueCollectorValueSource copy = new IssueCollectorValueSource();
        copy.clear();
        copy.m_resolutionModes.addAll(this.m_resolutionModes);
        copy.m_severities.addAll(this.m_severities);
        return copy;
    }

    @Override
    public String getPresentationName() {
        return "Issue Collector";
    }

    @Override
    public String getImageResourceName() {
        return "Issue";
    }

    public EnumSet<ResolutionMode> getAvailableResolutionModes() {
        return EnumSet.allOf(ResolutionMode.class);
    }

    public boolean containsResolutionMode(ResolutionMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'containsResolutionMode' must not be null";
        return this.m_resolutionModes.contains((Object)mode);
    }

    public void addResolutionMode(ResolutionMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'addResolutionMode' must not be null";
        this.m_resolutionModes.add(mode);
    }

    public void removeResolutionMode(ResolutionMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'removeResolutionMode' must not be null";
        this.m_resolutionModes.remove((Object)mode);
    }

    public EnumSet<ResolutionMode> getResolutionModes() {
        return this.m_resolutionModes;
    }

    public EnumSet<Severity> getAvailableSeverities() {
        return EnumSet.allOf(Severity.class);
    }

    public EnumSet<Severity> getSeverities() {
        return this.m_severities;
    }

    public void addSeverity(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'addSeverity' must not be null";
        this.m_severities.add(severity);
    }

    public void removeSeverity(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'removeSeverity' must not be null";
        this.m_severities.remove((Object)severity);
    }

    public boolean containsSeverity(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'containsSeverity' must not be null";
        return this.m_severities.contains((Object)severity);
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult result = super.isValid();
        if (this.m_resolutionModes.size() > 0 && this.m_severities.size() > 0) {
            return result;
        }
        if (this.m_resolutionModes.size() == 0 && this.m_severities.size() == 0) {
            result.addError("At least 1 resolution mode and 1 severity must be selected.");
            return result;
        }
        if (this.m_resolutionModes.size() == 0) {
            result.addError("At least 1 resolution mode must be selected.");
            return result;
        }
        assert (this.m_severities.size() == 0) : "Unexpected severity";
        result.addError("At least 1 severity must be selected.");
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_resolutionModes.hashCode();
        result = 31 * result + this.m_severities.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IssueCollectorValueSource other = (IssueCollectorValueSource)obj;
        return this.m_resolutionModes.equals(other.m_resolutionModes) && this.m_severities.equals(other.m_severities);
    }
}

