/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.transaction;

import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.NeedsReparse;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionType;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionContext.class);
    private final EnumSet<Modification> m_modifications = EnumSet.noneOf(Modification.class);
    private final String m_name;
    private final long m_id;
    private final boolean m_invalidatesParserModel;
    private final INavigationState m_navigationState;
    private final TransactionType m_transactionType;
    private Set<IModifiableFile> m_modifiedFiles;
    private Set<IModifiableFile> m_savedFiles;
    private Set<IModifiableFile> m_createdFiles;
    private Set<IModifiableFile> m_deletedFiles;
    private Set<IModifiableFile> m_reloadedFiles;
    private NeedsReparse m_needsReparseFlagModification;
    private SoftwareSystem m_softwareSystem;
    private List<String> m_nonParserModelFinished;
    private List<String> m_parserModelFinished;

    public TransactionContext(String name, boolean invalidatesParserModel, INavigationState navigationState, TransactionType type, long txId) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'TransactionContext' must not be empty";
        assert (type != null) : "Parameter 'type' of method 'TransactionContext' must not be null";
        this.m_name = name;
        this.m_id = txId;
        this.m_invalidatesParserModel = invalidatesParserModel;
        this.m_navigationState = navigationState;
        this.m_transactionType = type;
    }

    public long getId() {
        return this.m_id;
    }

    public TransactionType getTransactionType() {
        return this.m_transactionType;
    }

    private List<String> updateModelInfo(String model, List<String> modelInfo) {
        assert (model != null && model.length() > 0) : "Parameter 'model' of method 'updateModelInfo' must not be empty";
        if (modelInfo == null) {
            modelInfo = new ArrayList<String>(2);
        }
        String info = ExceptionUtility.collectAll((Throwable)new Throwable());
        if (!modelInfo.isEmpty()) {
            LOGGER.warn("### " + model + " already finished ###");
            LOGGER.warn("### Current: " + info);
            String previousInfo = modelInfo.get(modelInfo.size() - 1);
            LOGGER.warn("### Previous: " + previousInfo);
        }
        modelInfo.add(info);
        return modelInfo;
    }

    public void modelFinished(ModelFinishedMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'modelFinished' must not be null";
        switch (mode) {
            case NON_PARSER_MODEL: {
                this.m_nonParserModelFinished = this.updateModelInfo(mode.name(), this.m_nonParserModelFinished);
                break;
            }
            case PARSER_MODEL: {
                this.m_parserModelFinished = this.updateModelInfo(mode.name(), this.m_parserModelFinished);
                break;
            }
            default: {
                assert (false) : "Unhandled mode:" + String.valueOf((Object)mode);
                break;
            }
        }
    }

    public EnumSet<Modification> getModifications() {
        return EnumSet.copyOf(this.m_modifications);
    }

    public String getName() {
        return this.m_name;
    }

    public SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    public void setSoftwareSystem(SoftwareSystem softwareSystem) {
        this.m_softwareSystem = softwareSystem;
    }

    public boolean isEmpty() {
        return this.m_modifications.isEmpty() && this.m_modifiedFiles == null && this.m_savedFiles == null && this.m_createdFiles == null && this.m_deletedFiles == null && this.m_reloadedFiles == null;
    }

    public void addModifications(EnumSet<Modification> modifications) {
        assert (modifications != null) : "Parameter 'modifications' of method 'addModifications' must not be null";
        this.m_modifications.addAll(modifications);
    }

    public void addCreatedFiles(List<IModifiableFile> createdFiles) {
        assert (createdFiles != null && !createdFiles.isEmpty()) : "Parameter 'createdFiles' of method 'addCreatedFiles' must not be empty";
        if (this.m_createdFiles == null) {
            this.m_createdFiles = new LinkedHashSet<IModifiableFile>();
        }
        this.m_createdFiles.addAll(createdFiles);
    }

    public void addModifiedFiles(List<IModifiableFile> modifiedFiles) {
        assert (modifiedFiles != null && !modifiedFiles.isEmpty()) : "Parameter 'modifiedFiles' of method 'addModifiedFiles' must not be empty";
        if (this.m_modifiedFiles == null) {
            this.m_modifiedFiles = new LinkedHashSet<IModifiableFile>();
        }
        this.m_modifiedFiles.addAll(modifiedFiles);
    }

    public void addSavedFiles(List<IModifiableFile> savedFiles) {
        assert (savedFiles != null && !savedFiles.isEmpty()) : "Parameter 'savedFiles' of method 'addSavedFiles' must not be empty";
        if (this.m_savedFiles == null) {
            this.m_savedFiles = new LinkedHashSet<IModifiableFile>();
        }
        this.m_savedFiles.addAll(savedFiles);
    }

    public void addDeletedFiles(List<IModifiableFile> deletedFiles) {
        assert (deletedFiles != null && !deletedFiles.isEmpty()) : "Parameter 'deletedFiles' of method 'addDeletedFiles' must not be empty";
        if (this.m_deletedFiles == null) {
            this.m_deletedFiles = new LinkedHashSet<IModifiableFile>();
        }
        this.m_deletedFiles.addAll(deletedFiles);
    }

    public void addReloadedFiles(List<IModifiableFile> reloadedFiles) {
        assert (reloadedFiles != null && !reloadedFiles.isEmpty()) : "Parameter 'reloadedFiles' of method 'addReloadedFiles' must not be empty";
        if (this.m_reloadedFiles == null) {
            this.m_reloadedFiles = new LinkedHashSet<IModifiableFile>();
        }
        this.m_reloadedFiles.addAll(reloadedFiles);
    }

    public Set<IModifiableFile> getCreatedFiles() {
        if (this.m_createdFiles == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_createdFiles);
    }

    public Set<IModifiableFile> getModifiedFiles() {
        if (this.m_modifiedFiles == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_modifiedFiles);
    }

    public Set<IModifiableFile> getSavedFiles() {
        if (this.m_savedFiles == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_savedFiles);
    }

    public Set<IModifiableFile> getDeletedFiles() {
        if (this.m_deletedFiles == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_deletedFiles);
    }

    public Set<IModifiableFile> getReloadedFiles() {
        if (this.m_reloadedFiles == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_reloadedFiles);
    }

    public boolean invalidatesParserModel() {
        return this.m_invalidatesParserModel;
    }

    public void setNeedsReparseFlagModification(NeedsReparse modification) {
        assert (modification != null) : "Parameter 'modification' of method 'setNeedsReparseFlagModification' must not be null";
        this.m_needsReparseFlagModification = modification;
    }

    public NeedsReparse getNeedsReparseFlagModification() {
        assert (this.m_needsReparseFlagModification != null) : "'m_needsReparseFlagModification' in method 'getNeedsReparseFlagModification' must not be null";
        return this.m_needsReparseFlagModification;
    }

    public INavigationState getNavigationState() {
        return this.m_navigationState;
    }

    public String toString() {
        return this.m_name;
    }

    public static enum ModelFinishedMode {
        PARSER_MODEL,
        NON_PARSER_MODEL;

    }
}

