/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.settings;

import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectReferenceInfo;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SolutionFileInfo {
    private static final String CONFIGURATION_PLATFORM_SEPARATOR = "\\|";
    public static final char SEPARATOR = '|';
    private final TFile m_file;
    private final Map<String, IVisualStudioProjectReferenceInfo> m_projectKeyToProjectMap = new LinkedHashMap<String, IVisualStudioProjectReferenceInfo>();
    private final Map<String, ConfigurationAndPlatform> m_solutionConfigurationNames = new LinkedHashMap<String, ConfigurationAndPlatform>();
    private final Map<String, Map<ConfigurationAndPlatform, ConfigurationAndPlatform>> m_projectKeyToConfigurationMap = new LinkedHashMap<String, Map<ConfigurationAndPlatform, ConfigurationAndPlatform>>();
    private final List<IVisualStudioProjectReferenceInfo> m_omittedReferences = new ArrayList<IVisualStudioProjectReferenceInfo>();
    private final List<IVisualStudioProjectReferenceInfo> m_sharedProjectReferences = new ArrayList<IVisualStudioProjectReferenceInfo>();
    private String m_headerInfo;
    private Version m_visualStudioVersion;

    public SolutionFileInfo(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'SolutionFileInfo' must not be null";
        this.m_file = file;
    }

    public TFile getFile() {
        return this.m_file;
    }

    public void addConfigurationPlatformMapping(String configurationName, ConfigurationAndPlatform configurationAndPlatform) {
        assert (configurationName != null && configurationName.length() > 0) : "Parameter 'configurationName' of method 'addConfigurationName' must not be empty";
        assert (configurationAndPlatform != null) : "Parameter 'configurationAndPlatform' of method 'addConfigurationPlatformMapping' must not be null";
        this.m_solutionConfigurationNames.put(configurationName, configurationAndPlatform);
    }

    public void addProjectReference(IVisualStudioProjectReferenceInfo projectReference) {
        this.m_projectKeyToProjectMap.put(projectReference.getProjectKey(), projectReference);
    }

    public List<IVisualStudioProjectReferenceInfo> getProjectReferences() {
        return Collections.unmodifiableList(new ArrayList<IVisualStudioProjectReferenceInfo>(this.m_projectKeyToProjectMap.values()));
    }

    public List<ConfigurationAndPlatform> getConfigurations() {
        return Collections.unmodifiableList(new ArrayList<ConfigurationAndPlatform>(this.m_solutionConfigurationNames.values()));
    }

    public void addConfigurationMapping(ConfigurationAndPlatform solutionConfigurationAndPlatform, String projectKey, ConfigurationAndPlatform projectConfigurationAndPlatform) {
        Map<ConfigurationAndPlatform, ConfigurationAndPlatform> solutionConfigurationToProjectConfigurationMap = this.m_projectKeyToConfigurationMap.get(projectKey);
        if (solutionConfigurationToProjectConfigurationMap == null) {
            solutionConfigurationToProjectConfigurationMap = new HashMap<ConfigurationAndPlatform, ConfigurationAndPlatform>();
            this.m_projectKeyToConfigurationMap.put(projectKey, solutionConfigurationToProjectConfigurationMap);
        }
        solutionConfigurationToProjectConfigurationMap.put(solutionConfigurationAndPlatform, projectConfigurationAndPlatform);
    }

    public ConfigurationAndPlatform getConfigurationForProject(String projectKey, ConfigurationAndPlatform solutionConfigurationAndPlatform) {
        Map<ConfigurationAndPlatform, ConfigurationAndPlatform> projectConfigurations = this.m_projectKeyToConfigurationMap.get(projectKey);
        if (projectConfigurations == null) {
            return null;
        }
        return projectConfigurations.get(solutionConfigurationAndPlatform);
    }

    public Map<String, List<String>> getConfigurationPlatformMapping() {
        HashMap<String, List<String>> configurationPlatformMapping = new HashMap<String, List<String>>();
        for (String solutionConfiguration : this.m_solutionConfigurationNames.keySet()) {
            String[] parts = solutionConfiguration.split(CONFIGURATION_PLATFORM_SEPARATOR);
            assert (parts.length == 2) : "Expect two parts by splitting '" + solutionConfiguration + "' at char '|'";
            String config = parts[0];
            String platform = parts[1];
            ArrayList<String> platforms = (ArrayList<String>)configurationPlatformMapping.get(config);
            if (platforms == null) {
                platforms = new ArrayList<String>();
                configurationPlatformMapping.put(config, platforms);
            }
            if (platforms.contains(platform)) continue;
            platforms.add(platform);
        }
        for (List platforms : configurationPlatformMapping.values()) {
            Collections.sort(platforms);
        }
        return configurationPlatformMapping;
    }

    public void addOmittedReference(IVisualStudioProjectReferenceInfo reference) {
        assert (reference != null) : "Parameter 'reference' of method 'addOmittedReference' must not be null";
        this.m_omittedReferences.add(reference);
    }

    public List<IVisualStudioProjectReferenceInfo> getOmittedReferences() {
        return Collections.unmodifiableList(this.m_omittedReferences);
    }

    public void addSharedProjectReference(IVisualStudioProjectReferenceInfo reference) {
        assert (reference != null) : "Parameter 'reference' of method 'addSharedProjectReference' must not be null";
        this.m_sharedProjectReferences.add(reference);
    }

    public List<IVisualStudioProjectReferenceInfo> getSharedProjectReferences() {
        return Collections.unmodifiableList(this.m_sharedProjectReferences);
    }

    public boolean hasSharedProjectReferences() {
        return this.m_sharedProjectReferences.size() > 0;
    }

    public void setHeaderInfo(String headerInfo) {
        assert (headerInfo != null) : "Parameter 'headerInfo' of method 'setHeaderInfo' must not be null";
        this.m_headerInfo = headerInfo;
    }

    public String getHeaderInfo() {
        return this.m_headerInfo;
    }

    public Version getVisualStudioVersion() {
        return this.m_visualStudioVersion;
    }

    public void setVisualStudioVersion(String version) {
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'setVisualStudioVersion' must not be empty";
        Version exactVersion = Version.create((String)version);
        this.m_visualStudioVersion = Version.create((int)exactVersion.getMajor(), (int)exactVersion.getMinor(), (int)0, (int)0);
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("Solution file '").append(this.getFile().getAbsolutePath()).append("'").append(StringUtility.LINE_SEPARATOR);
        info.append("Header: ").append(StringUtility.LINE_SEPARATOR).append(this.getHeaderInfo()).append(StringUtility.LINE_SEPARATOR);
        if (this.m_visualStudioVersion != null) {
            info.append("VisualStudioVersion: ").append(this.m_visualStudioVersion.toString()).append(StringUtility.LINE_SEPARATOR);
        }
        info.append("Project references: ").append(StringUtility.LINE_SEPARATOR).append(this.getReferenceInfo(this.getProjectReferences())).append(StringUtility.LINE_SEPARATOR);
        info.append("Shared project references: ").append(StringUtility.LINE_SEPARATOR).append(this.getReferenceInfo(this.getSharedProjectReferences())).append(StringUtility.LINE_SEPARATOR);
        info.append("Omitted project references: ").append(StringUtility.LINE_SEPARATOR).append(this.getReferenceInfo(this.getSharedProjectReferences())).append(StringUtility.LINE_SEPARATOR);
        return info.toString();
    }

    private String getReferenceInfo(List<IVisualStudioProjectReferenceInfo> projectReferences) {
        assert (projectReferences != null) : "Parameter 'projectReferences' of method 'getReferenceInfo' must not be null";
        StringBuilder referenceInfo = new StringBuilder();
        for (IVisualStudioProjectReferenceInfo nextRef : projectReferences) {
            referenceInfo.append("Project name: '").append(nextRef.getName()).append("', file: '").append(nextRef.getFile().getPath()).append("', type: '").append(nextRef.getProjectType()).append("'");
            referenceInfo.append(StringUtility.LINE_SEPARATOR);
        }
        return referenceInfo.toString();
    }

    public String getProjectKeyByName(String projectName) {
        for (IVisualStudioProjectReferenceInfo info : this.m_projectKeyToProjectMap.values()) {
            if (!info.getName().equals(projectName)) continue;
            return info.getProjectKey();
        }
        return "";
    }

    public static class ConfigurationAndPlatform
    implements Comparable<ConfigurationAndPlatform> {
        private String m_platform;
        private final String m_configuration;
        private static final String SOLUTION_FILE_ANYCPU = "Any CPU";
        private static final String PROJECT_FILE_ANYCPU = "AnyCPU";
        public static final ConfigurationAndPlatform DEBUG_ANYCPU = new ConfigurationAndPlatform("Debug", "AnyCPU");
        public static final ConfigurationAndPlatform RELEASE_ANYCPU = new ConfigurationAndPlatform("Release", "AnyCPU");

        public ConfigurationAndPlatform(String configuration, String platform) {
            assert (configuration != null && configuration.length() > 0) : "Parameter 'configuration' of method 'ConfigurationAndPlatform' must not be empty";
            assert (platform != null && platform.length() > 0) : "Parameter 'platform' of method 'ConfigurationAndPlatform' must not be empty";
            this.m_configuration = configuration;
            this.m_platform = platform.equals(SOLUTION_FILE_ANYCPU) ? PROJECT_FILE_ANYCPU : platform;
        }

        public String getConfiguration() {
            return this.m_configuration;
        }

        public String getPlatform() {
            return this.m_platform;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_configuration == null ? 0 : this.m_configuration.hashCode());
            result = 31 * result + (this.m_platform == null ? 0 : this.m_platform.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigurationAndPlatform other = (ConfigurationAndPlatform)obj;
            if (this.m_configuration == null ? other.m_configuration != null : !this.m_configuration.equals(other.m_configuration)) {
                return false;
            }
            return !(this.m_platform == null ? other.m_platform != null : !this.m_platform.equals(other.m_platform));
        }

        public String toString() {
            return this.m_configuration + '|' + this.m_platform;
        }

        @Override
        public int compareTo(ConfigurationAndPlatform other) {
            if (other == null) {
                return 1;
            }
            int compareConfiguration = this.m_configuration.compareTo(other.m_configuration);
            if (compareConfiguration != 0) {
                return compareConfiguration;
            }
            return this.m_platform.compareTo(other.m_platform);
        }
    }
}

