/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractQualityGateMatchingElement
extends AbstractQualityGateElement {
    public static final String ANY = "Any";
    public static final String PARTS_SEPARATOR = ", ";
    private final String m_issueType;
    private final List<String> m_severities;
    private final List<String> m_resolutionTypes;

    protected AbstractQualityGateMatchingElement(NamedElement parent, String issueType, List<String> severities, List<String> resolutions) {
        super(parent);
        assert (issueType != null && issueType.length() > 0) : "Parameter 'issueType' of method 'AbstractQualityGateElement' must not be empty";
        assert (severities != null && !severities.isEmpty()) : "Parameter 'severities' of method 'AbstractQualityGateMatchingElement' must not be empty";
        assert (resolutions != null && !resolutions.isEmpty()) : "Parameter 'resolutions' of method 'AbstractQualityGateMatchingElement' must not be empty";
        this.m_issueType = issueType;
        this.m_severities = severities;
        this.m_resolutionTypes = resolutions;
    }

    @Override
    public String getDebugInfo() {
        return this.m_issueType + '|' + AbstractQualityGateMatchingElement.getSeverityAsString(this.m_severities) + '|' + AbstractQualityGateMatchingElement.getResolutionsAsString(this.m_resolutionTypes);
    }

    @Property
    public String getIssueType() {
        return this.m_issueType;
    }

    @Property
    public String getSeverity() {
        return AbstractQualityGateMatchingElement.getSeverityAsString(this.m_severities);
    }

    public final List<String> getSeverityList() {
        return Collections.unmodifiableList(this.m_severities);
    }

    public static final String getSeverityAsString(List<String> severities) {
        return severities.stream().collect(Collectors.joining(PARTS_SEPARATOR));
    }

    @Property
    public final String getResolution() {
        return AbstractQualityGateMatchingElement.getResolutionsAsString(this.m_resolutionTypes);
    }

    public final List<String> getResolutionList() {
        return Collections.unmodifiableList(this.m_resolutionTypes);
    }

    public static final String getResolutionsAsString(List<String> resolutions) {
        return resolutions.stream().collect(Collectors.joining(PARTS_SEPARATOR));
    }

    public static boolean doesIssueTypeSupportMetricId(String issueType) {
        return CoreIssueId.THRESHOLD_VIOLATION.getQualifiedName().equalsIgnoreCase(issueType) || ANY.equalsIgnoreCase(issueType);
    }

    public static boolean isMetricInfoRelevant(String issueType, String metricId) {
        if (AbstractQualityGateMatchingElement.doesIssueTypeSupportMetricId(issueType)) {
            return !ANY.equalsIgnoreCase(metricId);
        }
        return false;
    }
}

