/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.system.diff.ICompositeElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffUtility;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;

public abstract class CompositeElementDiff<B, C>
extends NamedElementContainer
implements ICompositeElementDiff<B, C> {
    private final B m_baseline;
    private final C m_current;
    private IDiffElement.Change m_change;
    private boolean m_changeHasBeenCalculated = false;

    protected CompositeElementDiff(NamedElement parent, B baseline, C current, IDiffElement.Change change) {
        super(parent);
        assert (baseline != null || current != null) : "Either baseline or current or both must not be null";
        assert (change != null) : "Parameter 'change' of method 'CompositeElementDelta' must not be null";
        this.m_baseline = baseline;
        this.m_current = current;
        this.m_change = change;
    }

    @Override
    public final B getBaseline() {
        return this.m_baseline;
    }

    @Override
    public final C getCurrent() {
        return this.m_current;
    }

    @Override
    public final NamedElement getElement() {
        return this;
    }

    @Override
    public final Element getCurrentElement() {
        if (this.m_current instanceof Element) {
            return (Element)this.m_current;
        }
        return null;
    }

    @Override
    @Property
    public final IDiffElement.Change getChange() {
        if (this.m_changeHasBeenCalculated) {
            return this.m_change;
        }
        boolean computeChangeDescription = true;
        switch (this.m_change) {
            case ADDED: {
                assert (this.m_baseline == null) : "Inconsistent change: baseline must be null";
                break;
            }
            case REMOVED: {
                assert (this.m_current == null) : "Inconsistent change: current must be null";
                break;
            }
            case UNMODIFIED: {
                this.m_change = this.calculateChange();
                computeChangeDescription = false;
                break;
            }
            case WORSENED: {
                break;
            }
            case IMPROVED: {
                break;
            }
            case MODIFIED: {
                break;
            }
            case RESOLUTION_ADDED: {
                break;
            }
            case RESOLUTION_REMOVED: {
                break;
            }
            default: {
                assert (false) : "Unsupported change: " + this.m_change.getStandardName();
                break;
            }
        }
        if (computeChangeDescription) {
            this.computeChangeDescription(this.m_change);
        }
        this.m_changeHasBeenCalculated = true;
        return this.m_change;
    }

    protected void computeChangeDescription(IDiffElement.Change change) {
    }

    protected IDiffElement.Change calculateChange() {
        return SystemDiffUtility.calculateChange(this, this.m_change);
    }

    @Override
    @Property
    public String getChangeDescription() {
        IDiffElement.Change change = this.getChange();
        if (change == IDiffElement.Change.UNMODIFIED || change == IDiffElement.Change.ADDED || change == IDiffElement.Change.REMOVED) {
            return "";
        }
        if (SystemDiffUtility.anyChildrenChanged(this)) {
            return "Contained elements changed.";
        }
        return this.getChange().getPresentationName();
    }
}

