/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.PhysicalImpactDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class OneEndpoint
extends PhysicalImpactDependencyEndpointCollector {
    private final Set<Module> m_parentModules;
    private final List<NamedElement> m_physicalNamedElements;
    private final Set<ProgrammingElement> m_childProgrammingElements;
    private final NamedElement m_endpoint;
    private final boolean m_isProgrammingElement;
    private final boolean m_flat;

    OneEndpoint(NamedElement endpoint, Set<Module> parentModules, List<NamedElement> physicalNamedElements, Set<ProgrammingElement> childProgrammingElements, boolean flat) {
        assert (endpoint != null) : "Parameter 'endpoint' of method 'OneEndpoint' must not be null";
        assert (parentModules != null && !parentModules.isEmpty()) : "Parameter 'parentModules' of method 'OneEndpoint' must not be empty";
        assert (physicalNamedElements != null && !physicalNamedElements.isEmpty()) : "Parameter 'physicalNamedElements' of method 'OneEndpoint' must not be empty";
        assert (childProgrammingElements != null && !childProgrammingElements.isEmpty()) : "Parameter 'childProgrammingElements' of method 'OneEndpoint' must not be empty";
        this.m_parentModules = parentModules;
        this.m_physicalNamedElements = physicalNamedElements;
        this.m_childProgrammingElements = childProgrammingElements;
        this.m_endpoint = endpoint;
        this.m_isProgrammingElement = endpoint instanceof ProgrammingElement;
        this.m_flat = flat;
    }

    @Override
    public Collection<ProgrammingElement> getProgrammingElements(NamedElement forNamedElement) {
        assert (forNamedElement != null) : "Parameter 'forNamedElement' of method 'getProgrammingElements' must not be null";
        if (this.m_flat && OneEndpoint.isRecursiveElement(forNamedElement)) {
            if (this.m_parentModules.contains(forNamedElement)) {
                Set<ProgrammingElement> all = OneEndpoint.getProgrammingElementsFlat(forNamedElement);
                all.removeAll(this.m_childProgrammingElements);
                return all;
            }
            return OneEndpoint.getProgrammingElementsFlat(forNamedElement);
        }
        if (this.m_parentModules.contains(forNamedElement)) {
            Collection<ProgrammingElement> all = super.getProgrammingElements(forNamedElement);
            all.removeAll(this.m_childProgrammingElements);
            return all;
        }
        return super.getProgrammingElements(forNamedElement);
    }

    @Override
    public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
        assert (dependency != null && dependency instanceof ParserDependency) : "Unexpected class in method 'addDependency': " + String.valueOf(dependency);
        if (from != to) {
            if (this.m_isProgrammingElement) {
                ISnapshotDependency.IDependencyEndpoint fromEndpoint = dependency.getFrom();
                assert (fromEndpoint != null && fromEndpoint instanceof ProgrammingElement) : "Unexpected class in method 'addDependency': " + String.valueOf(fromEndpoint);
                ProgrammingElement fromProgrammingElement = (ProgrammingElement)fromEndpoint;
                ISnapshotDependency.IDependencyEndpoint toEndpoint = dependency.getTo();
                assert (toEndpoint != null && toEndpoint instanceof ProgrammingElement) : "Unexpected class in method 'addDependency': " + String.valueOf(toEndpoint);
                ProgrammingElement toProgrammingElement = (ProgrammingElement)toEndpoint;
                if ((fromProgrammingElement == this.m_endpoint || fromProgrammingElement.hasAsParent(this.m_endpoint, false)) && (toProgrammingElement == this.m_endpoint || toProgrammingElement.hasAsParent(this.m_endpoint, false))) {
                    return false;
                }
            }
            if (this.m_flat) {
                return this.m_childProgrammingElements.contains(dependency.getTo());
            }
            return this.m_physicalNamedElements.contains(to);
        }
        return false;
    }
}

