/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.resolution;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class Matching
extends NamedElement {
    private final List<Pair<String, IntBasedHash>> m_elementFqNameToHash = new ArrayList<Pair<String, IntBasedHash>>();
    private String m_info;

    public Matching(NamedElement parent, String info) {
        super(parent);
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'Matching' must not be empty";
        this.m_info = info;
    }

    @Override
    public String getInformation() {
        return this.m_info;
    }

    public void setInformation(String info) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'setInformation' must not be empty";
        this.m_info = info;
    }

    @Override
    public String getShortName() {
        return this.m_info;
    }

    @Override
    public String getFullyQualifiedName() {
        return null;
    }

    @Override
    public String getOriginalFullyQualifiedName() {
        return null;
    }

    public void addElementFqName(String fqName) {
        assert (fqName != null && fqName.length() > 0) : "Parameter 'fqName' of method 'addElementFqName' must not be empty";
        this.m_elementFqNameToHash.add((Pair<String, IntBasedHash>)new Pair((Object)fqName, null));
    }

    public void addElementFqName(String fqName, IntBasedHash hash) {
        assert (fqName != null && fqName.length() > 0) : "Parameter 'fqName' of method 'addElementFqName' must not be empty";
        assert (hash != null && hash.length() > 0) : "Parameter 'hash' of method 'addElementFqName' must not be empty";
        this.m_elementFqNameToHash.add((Pair<String, IntBasedHash>)new Pair((Object)fqName, (Object)hash));
    }

    public void setElementFqNames(Collection<String> elementFqNames) {
        assert (elementFqNames != null) : "Parameter 'elementFqNames' of method 'setElementFqNames' must not be null";
        this.m_elementFqNameToHash.clear();
        elementFqNames.forEach(fq -> {
            boolean bl = this.m_elementFqNameToHash.add((Pair<String, IntBasedHash>)new Pair(fq, null));
        });
    }

    public void setElementFqNamesAndHashes(List<StrictPair<String, IntBasedHash>> fqNamesAndHashes) {
        assert (fqNamesAndHashes != null) : "Parameter 'fqNamesAndHashes' of method 'setElementFqNamesAndHashes' must not be null";
        this.m_elementFqNameToHash.clear();
        fqNamesAndHashes.forEach(pair -> {
            boolean bl = this.m_elementFqNameToHash.add((Pair<String, IntBasedHash>)new Pair((Object)((String)pair.getFirst()), (Object)((IntBasedHash)pair.getSecond())));
        });
    }

    public List<String> getElementFqNames() {
        return this.m_elementFqNameToHash.stream().map(pair -> (String)pair.getFirst()).collect(Collectors.toList());
    }

    public List<Pair<String, IntBasedHash>> getElementFqNamesAndHashs() {
        return this.m_elementFqNameToHash;
    }

    public Set<IntBasedHash> getHashs() {
        LinkedHashSet<IntBasedHash> hashes = new LinkedHashSet<IntBasedHash>();
        for (Pair<String, IntBasedHash> next : this.m_elementFqNameToHash) {
            if (next.getSecond() == null) continue;
            hashes.add((IntBasedHash)next.getSecond());
        }
        return hashes;
    }

    public void resetHashs() {
        ArrayList<Pair<String, IntBasedHash>> copy = new ArrayList<Pair<String, IntBasedHash>>(this.m_elementFqNameToHash);
        this.m_elementFqNameToHash.clear();
        for (Pair pair : copy) {
            this.m_elementFqNameToHash.add((Pair<String, IntBasedHash>)new Pair((Object)((String)pair.getFirst()), null));
        }
    }
}

