/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import com.hello2morrow.sonargraph.core.model.representation.ProgrammingElementDelta;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class ProgrammingElementDeltaManager {
    private final TreeMap<Integer, ProgrammingElementDelta> m_states = new TreeMap();
    private final Collection<ProgrammingElement> m_mainNodeProgrammingElements;
    private final Collection<ProgrammingElement> m_additionalNodeProgrammingElements;
    private int m_currentStateId = -1;
    private int m_currentStateInViewId = -1;
    private ProgrammingElementDelta m_currentStateInViewDelta;
    private boolean m_useCurrentStateInview = false;

    public ProgrammingElementDeltaManager(int stateId) {
        this.m_mainNodeProgrammingElements = Collections.emptySet();
        this.m_additionalNodeProgrammingElements = Collections.emptySet();
        this.m_states.put(stateId, new ProgrammingElementDelta());
        this.m_currentStateId = stateId;
        this.checkStateIdIntegrity();
    }

    public ProgrammingElementDeltaManager(Collection<ProgrammingElement> mainNodeProgrammingElements, Collection<ProgrammingElement> additionalNodeProgrammingElements, int stateId) {
        assert (mainNodeProgrammingElements != null) : "Parameter 'mainNodeProgrammingElements' of method 'ProgrammingElementCollectionManager' must not be null";
        assert (additionalNodeProgrammingElements != null) : "Parameter 'additionalNodeProgrammingElements' of method 'ProgrammingElementCollectionManager' must not be null";
        this.m_mainNodeProgrammingElements = mainNodeProgrammingElements;
        this.m_additionalNodeProgrammingElements = additionalNodeProgrammingElements;
        this.m_states.put(stateId, new ProgrammingElementDelta());
        this.m_currentStateId = stateId;
        this.checkStateIdIntegrity();
    }

    private void checkStateIdIntegrity() {
        if (this.m_states.isEmpty()) {
            assert (this.m_currentStateId == -1) : "'m_currentIndex' must be '-1'";
        } else assert (this.m_states.containsKey(this.m_currentStateId)) : "'m_currentIndex' " + this.m_currentStateId + " does not point to any object";
    }

    public int getCurrentStateId() {
        return this.m_currentStateId;
    }

    public void setCurrentStateId(int stateId) {
        if (this.m_states.containsKey(stateId)) {
            this.m_currentStateId = stateId;
        } else {
            this.m_states.put(stateId, new ProgrammingElementDelta());
        }
        this.checkStateIdIntegrity();
    }

    public void createDelta(Collection<ProgrammingElement> mainNodeProgrammingElements, Collection<ProgrammingElement> additionalNodeProgrammingElements, int stateId) {
        assert (mainNodeProgrammingElements != null) : "Parameter 'mainNodeProgrammingElements' of method 'createDelta' must not be null";
        assert (additionalNodeProgrammingElements != null) : "Parameter 'additionalNodeProgrammingElements' of createDelta 'findDeltas' must not be null";
        HashSet<ProgrammingElement> originalInputDeletion = new HashSet<ProgrammingElement>(this.m_mainNodeProgrammingElements);
        originalInputDeletion.removeAll(mainNodeProgrammingElements);
        HashSet<ProgrammingElement> additionalsDeletion = new HashSet<ProgrammingElement>(this.m_additionalNodeProgrammingElements);
        additionalsDeletion.removeAll(additionalNodeProgrammingElements);
        mainNodeProgrammingElements.removeAll(this.m_mainNodeProgrammingElements);
        additionalNodeProgrammingElements.removeAll(this.m_additionalNodeProgrammingElements);
        this.m_states.put(stateId, new ProgrammingElementDelta(mainNodeProgrammingElements, additionalNodeProgrammingElements, originalInputDeletion, additionalsDeletion));
        this.m_currentStateId = stateId;
        this.m_currentStateInViewId = stateId;
        this.checkStateIdIntegrity();
    }

    public void createDelta(int stateId) {
        if (this.m_currentStateId == -1) {
            this.m_states.put(stateId, new ProgrammingElementDelta());
            this.m_currentStateId = stateId;
        } else {
            ProgrammingElementDelta currentState = this.m_states.get(this.m_currentStateId);
            assert (currentState != null) : "'currentState' of method 'createDelta' must not be null";
            this.m_states.put(stateId, currentState);
            this.m_currentStateId = stateId;
        }
        this.checkStateIdIntegrity();
    }

    public void applyDelta(int stateId) {
        this.m_useCurrentStateInview = false;
        this.m_currentStateId = stateId;
        this.checkStateIdIntegrity();
    }

    public void applyCurrentViewState() {
        this.m_useCurrentStateInview = true;
    }

    public void removeDeltas(List<Integer> stateIds) {
        assert (stateIds != null) : "Parameter 'stateIds' of method 'removeDeltas' must not be null";
        boolean adjustCurrentStateId = false;
        Collections.sort(stateIds);
        if (this.m_currentStateId >= stateIds.get(0) && this.m_currentStateId <= stateIds.get(stateIds.size() - 1)) {
            adjustCurrentStateId = true;
        }
        for (Integer id : stateIds) {
            this.m_states.remove(id);
        }
        if (adjustCurrentStateId) {
            this.m_currentStateId = this.m_states.isEmpty() ? -1 : this.m_states.lastKey();
        }
        this.checkStateIdIntegrity();
    }

    private Set<ProgrammingElement> applyDeltaToCurrentState(NodeType nodeType) {
        HashSet<ProgrammingElement> result;
        assert (nodeType != null) : "Parameter 'collection' of method 'applyDeltaToCurrentState' must not be null";
        ProgrammingElementDelta state = this.m_useCurrentStateInview ? this.m_currentStateInViewDelta : this.m_states.get(this.m_currentStateId);
        assert (state != null) : "Parameter 'state' of method 'applyDeltaToCurrentState' must not be null";
        switch (nodeType) {
            case MAIN: {
                result = new HashSet<ProgrammingElement>(this.m_mainNodeProgrammingElements);
                result.removeAll(state.getMainNodeDeletions());
                result.addAll(state.getMainNodeInsertions());
                break;
            }
            case ADDITIONAL: {
                result = new HashSet<ProgrammingElement>(this.m_additionalNodeProgrammingElements);
                result.removeAll(state.getAdditionalNodeDeletions());
                result.addAll(state.getAdditionalNodeInsertions());
                break;
            }
            case ORIGINAL: {
                result = null;
                assert (false) : "Not supported in delta: " + String.valueOf((Object)nodeType);
                break;
            }
            default: {
                result = null;
                assert (false) : "Unhandled node type: " + String.valueOf((Object)nodeType);
                break;
            }
        }
        return result;
    }

    public void setCurrentDeltaForView(int stateId) {
        this.m_currentStateInViewDelta = this.m_states.get(stateId);
        assert (this.m_currentStateInViewDelta != null) : "No delta found for id: " + stateId;
        this.m_currentStateInViewId = stateId;
    }

    public int getCurrentStateInViewId() {
        return this.m_currentStateInViewId;
    }

    public Set<ProgrammingElement> getMainNodeProgrammingElements() {
        return this.applyDeltaToCurrentState(NodeType.MAIN);
    }

    public Set<ProgrammingElement> getAdditionalNodeProgrammingElements() {
        return this.applyDeltaToCurrentState(NodeType.ADDITIONAL);
    }

    public Set<Map.Entry<Integer, ProgrammingElementDelta>> getDeltasAsEntrySet() {
        return this.m_states.entrySet().isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this.m_states.entrySet());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Main Node (").append(this.m_mainNodeProgrammingElements.size()).append(")");
        builder.append(" ");
        builder.append("Additional Node (").append(this.m_additionalNodeProgrammingElements.size()).append(")");
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("------------------------------------------------------------------------------------");
        builder.append(StringUtility.LINE_SEPARATOR);
        for (Map.Entry<Integer, ProgrammingElementDelta> entry : this.m_states.entrySet()) {
            builder.append("[");
            builder.append("ID: ").append(String.valueOf(entry.getKey()) + "| ");
            ProgrammingElementDelta delta = entry.getValue();
            builder.append(delta.toString());
            builder.append("]");
            if (entry.getKey() == this.m_currentStateId) {
                builder.append(" (current)");
            }
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        return builder.toString();
    }
}

