/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.sonargraph.core.model.element.CoreStructureItem;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationDependency;
import com.hello2morrow.sonargraph.core.model.system.StructureInfo;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BalancedDependency
extends RepresentationDependency
implements IParserDependenciesProvidingEdge {
    private static final String AGGREGATED_DEPENDENCY = "Aggregated";
    private final StructureInfo m_structureInfo;
    private final List<ParserDependency> m_parserDependencies = new ArrayList<ParserDependency>();
    private final DependencyType m_dependencyType;
    private final NamedElement m_from;
    private final NamedElement m_to;
    private boolean m_specialBalance = false;
    private boolean m_hasBeenExpanded = false;
    private BalanceMode m_balanceMode;
    private BalancedDependency m_parent;
    private Set<BalancedDependency> m_children;
    private final boolean m_architectureEnabled;

    public BalancedDependency(StructureInfo structureInfo, BalancedDependency parent, NamedElement from, NamedElement to, DependencyType type, boolean architectureEnabled) {
        assert (structureInfo != null) : "Parameter 'structureInfo' of method 'BalancedDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'BalancedDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'BalancedDependency' must not be null";
        assert (type != null) : "Parameter 'type' of method 'SymmetricDependency' must not be null";
        assert (structureInfo.isInStructure(from.getStructureItem())) : String.valueOf(from.getStructureItem()) + " not in " + String.valueOf(structureInfo);
        assert (structureInfo.isInStructure(to.getStructureItem())) : String.valueOf(to.getStructureItem()) + " not in " + String.valueOf(structureInfo);
        this.m_structureInfo = structureInfo;
        this.m_parent = parent;
        this.m_from = from.getOriginal();
        this.m_to = to.getOriginal();
        this.m_balanceMode = BalanceMode.BALANCED;
        this.m_dependencyType = type;
        this.m_architectureEnabled = architectureEnabled;
    }

    public void accept(IBalancedDependencyVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        visitor.visitBalancedDependency(this);
    }

    @Override
    public final Element getElement() {
        return this.m_parserDependencies.size() == 1 ? this.getFirstDependency() : this;
    }

    @Override
    public final NamedElement getFromEndPoint() {
        return this.m_from.getRepresentative();
    }

    @Override
    public final NamedElement getToEndPoint() {
        return this.m_to.getRepresentative();
    }

    @Override
    public final int getWeight() {
        return this.m_parserDependencies.size();
    }

    @Override
    @IntProperty
    public int getNumberOfParserDependencies() {
        return this.m_parserDependencies.size();
    }

    @Override
    public final ParserDependency getFirstDependency() {
        if (this.m_parserDependencies.size() >= 1) {
            return this.m_parserDependencies.get(0);
        }
        return null;
    }

    public final ParserDependency getLowestLineNumberParserDependency() {
        ParserDependency lowestNumberDependency = null;
        for (ParserDependency parserDependency : this.m_parserDependencies) {
            if (lowestNumberDependency != null && parserDependency.getLineNumber() >= lowestNumberDependency.getLineNumber()) continue;
            lowestNumberDependency = parserDependency;
        }
        assert (lowestNumberDependency != null) : "Parameter 'lowestNumberDependency' of method 'getLowestLineNumberParserDependency' must not be null";
        return lowestNumberDependency;
    }

    public final boolean isLeaf() {
        return this.m_structureInfo.isLastElementInStructure(this.getFromEndPoint().getStructureItem()) && this.m_structureInfo.isLastElementInStructure(this.getToEndPoint().getStructureItem()) || this.getFromEndPoint().isOfStructureItem(CoreStructureItem.INTERNAL_COMPONENT) && this.getToEndPoint().isOfStructureItem(CoreStructureItem.INTERNAL_COMPONENT);
    }

    public final void addAllChildren(Collection<BalancedDependency> children) {
        assert (children != null) : "Parameter 'children' of method 'addAllChildren' must not be null";
        if (this.m_children == null) {
            this.m_children = new LinkedHashSet<BalancedDependency>(children.size());
        }
        this.m_children.addAll(children);
        this.m_hasBeenExpanded = true;
    }

    public final BalancedDependency getParent() {
        return this.m_parent;
    }

    public final void setParent(BalancedDependency parent) {
        this.m_parent = parent;
    }

    public final boolean hasParent() {
        return this.m_parent != null;
    }

    public final Collection<BalancedDependency> getChildren() {
        if (this.m_children == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_children);
    }

    public final boolean hasChildren() {
        return this.m_children != null && this.m_children.size() > 0;
    }

    public final void removeAllChildren() {
        assert (this.m_children != null) : "Parameter 'm_children' of method 'removeAllChildren' must not be null";
        this.m_children.clear();
        this.m_hasBeenExpanded = false;
    }

    public final void setBalanceMode(BalanceMode balanceMode) {
        assert (balanceMode != null) : "Parameter 'balanceMode' of method 'setPlaceholderUse' must not be null";
        this.m_balanceMode = balanceMode;
    }

    public boolean isSpecialBalance() {
        return this.m_specialBalance;
    }

    public void setSpecialBalance(boolean specialBalance) {
        this.m_specialBalance = specialBalance;
    }

    public final BalanceMode getBalanceMode() {
        return this.m_balanceMode;
    }

    public final boolean usesFromPlaceHolder() {
        return this.m_balanceMode == BalanceMode.UNBALANCED_IN_FROM;
    }

    public final boolean usesToPlaceHolder() {
        return this.m_balanceMode == BalanceMode.UNBALANCED_IN_TO;
    }

    public final boolean hasBeenExpanded() {
        return this.m_hasBeenExpanded;
    }

    public final String getDependencyInfo() {
        if (this.m_parserDependencies.size() == 1) {
            return this.getFirstDependency().getDependencyInfo();
        }
        return AGGREGATED_DEPENDENCY;
    }

    public final List<ParserDependency> getDependencies() {
        return this.m_parserDependencies;
    }

    public final List<ParserDependency> getParserDependencies() {
        return this.m_parserDependencies;
    }

    public final String getFromPresentationName(boolean shortName) {
        return this.getFromEndPoint().getPresentationName(shortName);
    }

    public final String getToPresentationName(boolean shortName) {
        return this.getToEndPoint().getPresentationName(shortName);
    }

    public final DependencyType getDependencyType() {
        return this.m_dependencyType;
    }

    public final void addDependency(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addDependency' must not be null";
        this.m_parserDependencies.add(dependency);
    }

    public final void addDependencies(Collection<ParserDependency> dependencies) {
        assert (dependencies != null) : "Parameter 'dependencies' of method 'addDependencies' must not be null";
        for (ParserDependency parserDependency : dependencies) {
            this.addDependency(parserDependency);
        }
    }

    public final StructureInfo getStructureInfo() {
        return this.m_structureInfo;
    }

    @Override
    public EndpointType getEndpointType() {
        return EndpointType.PARSER_DEPENDENCY;
    }

    @Override
    public final String getShortName() {
        if (this.m_parserDependencies.size() == 1) {
            return this.getFirstDependency().getName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFromEndPoint().getName());
        builder.append(" -> ");
        builder.append(this.getToEndPoint().getName());
        return builder.toString();
    }

    @Override
    public final String getPresentationName(boolean inContext) {
        if (this.m_parserDependencies.size() == 1) {
            return this.getFirstDependency().getPresentationName(inContext);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFromEndPoint().getPresentationName(inContext));
        builder.append(" -> ");
        builder.append(this.getToEndPoint().getPresentationName(inContext));
        return builder.toString();
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this.getFromEndPoint().getPropertiesManager();
    }

    @Override
    public final boolean hasUnresolvedErrorIssues() {
        if (this.m_parserDependencies.size() == 1) {
            this.getFirstDependency().hasUnresolvedErrorIssues();
        }
        return false;
    }

    @Override
    public final boolean hasUnresolvedWarningIssues() {
        if (this.m_parserDependencies.size() == 1) {
            this.getFirstDependency().hasUnresolvedWarningIssues();
        }
        return false;
    }

    @Override
    public final boolean isExternal() {
        return this.getFromEndPoint().isExternal();
    }

    @Override
    public final boolean isExcluded() {
        return this.getFromEndPoint().isExcluded();
    }

    @Override
    public final boolean ignoreIssues() {
        return this.getFromEndPoint().ignoreIssues();
    }

    @Override
    public final boolean isValid() {
        if (this.m_parserDependencies.size() == 1) {
            return this.getFirstDependency().isValid();
        }
        return this.getFromEndPoint().isValid() && this.getToEndPoint().isValid();
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_parserDependencies == null ? 0 : this.m_parserDependencies.hashCode());
        result = 31 * result + (this.m_from == null ? 0 : this.m_from.hashCode());
        result = 31 * result + (this.m_to == null ? 0 : this.m_to.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BalancedDependency other = (BalancedDependency)obj;
        if (this.m_parserDependencies == null ? other.m_parserDependencies != null : !this.m_parserDependencies.equals(other.m_parserDependencies)) {
            return false;
        }
        if (this.m_from == null ? other.m_from != null : !this.m_from.equals(other.m_from)) {
            return false;
        }
        return !(this.m_to == null ? other.m_to != null : !this.m_to.equals(other.m_to));
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        if (this.m_parserDependencies.size() == 1) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(this.getFirstDependency().getDebugInfo());
        } else {
            builder.append(this.getFromEndPoint().getPresentationName(true));
            builder.append(" -> ");
            builder.append(this.getToEndPoint().getPresentationName(true));
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFromEndPoint().getName());
        builder.append(" -> ");
        builder.append(this.getToEndPoint().getName());
        return builder.toString();
    }

    @Override
    public final String getImageResourceName() {
        EdgeAdapter.ArchitectureViolationMode violationMode = this.m_architectureEnabled ? this.getArchitectureViolationMode() : EdgeAdapter.ArchitectureViolationMode.ARCHITECTURE_NOT_ENABLED;
        switch (violationMode) {
            case ARCHITECTURE_NOT_ENABLED: 
            case NOT_RELEVANT_FOR_ARCHITECTURE: {
                if (this.m_dependencyType == DependencyType.INCOMING) {
                    return "ArrowGrayLeft";
                }
                return "ArrowGrayRight";
            }
            case PARTIAL_VIOLATION: {
                if (this.m_dependencyType == DependencyType.INCOMING) {
                    return "ArrowYellowLeft";
                }
                return "ArrowYellowRight";
            }
            case FULL_VIOLATION: {
                if (this.m_dependencyType == DependencyType.INCOMING) {
                    return "ArrowRedLeft";
                }
                return "ArrowRedRight";
            }
            case NO_VIOLATIONS: {
                if (this.m_dependencyType == DependencyType.INCOMING) {
                    return "ArrowGreenLeft";
                }
                return "ArrowGreenRight";
            }
        }
        assert (false) : "Unexpected violation mode:" + String.valueOf((Object)violationMode);
        return null;
    }

    @Override
    public Element getDependency() {
        return this;
    }

    @Override
    public ParserDependency getFirstParserDependency() {
        return !this.m_parserDependencies.isEmpty() ? this.m_parserDependencies.get(0) : null;
    }

    public static enum BalanceMode {
        BALANCED,
        UNBALANCED_IN_FROM,
        UNBALANCED_IN_TO;

    }

    public static enum CompareMode {
        FROM,
        TO,
        BOTH;

    }

    public static interface IBalancedDependencyVisitor {
        public void visitBalancedDependency(BalancedDependency var1);

        default public void visitChildrenOf(BalancedDependency dependency) {
            for (BalancedDependency child : dependency.getChildren()) {
                child.accept(this);
            }
        }
    }
}

