/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import java.util.ArrayList;
import java.util.List;

public final class MoveRenameRefactoringInfo {
    private final Language m_language;
    private final RefactoringType m_refactoringType;
    private final MoveRenameRefactoringElementType m_refactoringElementType;
    private final String m_elementTypePresentationName;
    private final List<NamedElement> m_elements;
    private IRefactoringTarget m_refactoringTarget;

    public MoveRenameRefactoringInfo(Language language, RefactoringType type, MoveRenameRefactoringElementType elementType, String elementTypePresentationName, List<NamedElement> elements) {
        assert (language != null) : "Parameter 'language' of method 'MoveRenameRefactoringInfo' must not be null";
        assert (type != null) : "Parameter 'type' of method 'MoveRenameRefactoringInfo' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'MoveRenameRefactoringInfo' must not be null";
        assert (elementTypePresentationName != null && elementTypePresentationName.length() > 0) : "Parameter 'elementTypePresentationName' of method 'MoveRenameRefactoringInfo' must not be empty";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'MoveRenameRefactoringInfo' must not be empty";
        assert (type != RefactoringType.NONE && type != RefactoringType.DELETE) : "Not a move/rename refactoring: " + String.valueOf((Object)type);
        this.m_language = language;
        this.m_refactoringType = type;
        this.m_refactoringElementType = elementType;
        this.m_elementTypePresentationName = elementTypePresentationName;
        this.m_elements = new ArrayList<NamedElement>(elements);
    }

    public RefactoringType getRefactoringType() {
        return this.m_refactoringType;
    }

    public MoveRenameRefactoringElementType getRefactoringElementType() {
        return this.m_refactoringElementType;
    }

    public String getRefactoringElementTypePresentationName() {
        return this.m_elementTypePresentationName;
    }

    public Language getLanguage() {
        return this.m_language;
    }

    public List<NamedElement> getElements() {
        return this.m_elements;
    }

    public void setRefactoringTarget(IRefactoringTarget refactoringTarget) {
        assert (refactoringTarget != null) : "Parameter 'refactoringTarget' of method 'setRefactoringTarget' must not be null";
        this.m_refactoringTarget = refactoringTarget;
    }

    public IRefactoringTarget getRefactoringTarget() {
        return this.m_refactoringTarget;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.m_language.getPresentationName()).append("] ").append(this.m_refactoringType.getPresentationName()).append(": ").append(this.m_refactoringElementType.getPresentationName());
        if (this.m_refactoringTarget != null) {
            builder.append(" - target: ").append(this.m_refactoringTarget.getNamedElement().getPresentationName(false)).append(" (").append(this.m_refactoringTarget.getClass().getSimpleName()).append("");
        }
        builder.append("\n").append(this.m_elements.size()).append(" element(s):");
        int i = 1;
        for (NamedElement next : this.m_elements) {
            builder.append("\n");
            builder.append("[").append(i).append("] ").append(next.getPresentationName(false)).append(" (").append(next.getClass().getSimpleName()).append(")").append("");
            ++i;
        }
        return builder.toString();
    }
}

