/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ParserDependencyEdgeAdapter<T extends INode<NamedElement>>
extends EdgeAdapter<T> {
    private List<ParserDependency> m_dependencies;

    public ParserDependencyEdgeAdapter(T from, T to) {
        super(from, to);
    }

    public ParserDependencyEdgeAdapter(ParserDependencyEdgeAdapter<T> edge, T to) {
        super(edge.getFrom(), to);
        this.m_dependencies = edge.m_dependencies;
        edge.m_dependencies = null;
    }

    public ParserDependencyEdgeAdapter(T from, ParserDependencyEdgeAdapter<T> edge) {
        super(from, edge.getTo());
        this.m_dependencies = edge.m_dependencies;
        edge.m_dependencies = null;
    }

    @Override
    public int getNumberOfDependencies() {
        return this.m_dependencies == null ? 0 : this.m_dependencies.size();
    }

    @Override
    public int getWeight() {
        return this.getNumberOfDependencies();
    }

    @Override
    public int getNumberOfParserDependencies() {
        return this.getNumberOfDependencies();
    }

    @Override
    public void addDependency(Dependency dependency) {
        assert (dependency != null && dependency instanceof ParserDependency) : "Unexpected class in method 'addDependency': " + String.valueOf(dependency);
        if (this.m_dependencies == null) {
            this.m_dependencies = new ArrayList<ParserDependency>();
        }
        this.m_dependencies.add((ParserDependency)dependency);
    }

    public void addDependencies(Collection<ParserDependency> dependencies) {
        assert (dependencies != null);
        if (this.m_dependencies == null) {
            this.m_dependencies = new ArrayList<ParserDependency>();
        }
        this.m_dependencies.addAll(dependencies);
    }

    @Override
    public List<ParserDependency> getDependencies() {
        return this.m_dependencies != null ? Collections.unmodifiableList(this.m_dependencies) : Collections.emptyList();
    }

    public Iterator<ParserDependency> getDependenciesIterator() {
        return this.m_dependencies != null ? this.m_dependencies.iterator() : Collections.emptyList().iterator();
    }

    @Override
    public ParserDependency getFirstDependency() {
        return this.getNumberOfDependencies() >= 1 ? this.m_dependencies.get(0) : null;
    }

    @Override
    public EndpointType getEndpointType() {
        return EndpointType.PARSER_DEPENDENCY;
    }
}

