/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.annotation.Annotation;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IPhysicalElement;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.programming.ArchitectureCheckIssueVisitor;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependencyContext;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;

public abstract class ParserDependency
extends Dependency
implements IPhysicalElement {
    private ProgrammingElement m_from;
    private ProgrammingElement m_to;

    protected ParserDependency(ProgrammingElement from) {
        assert (from != null) : "Parameter 'from' of method 'Dependency' must not be null";
        this.m_from = from;
    }

    protected ParserDependency(ProgrammingElement from, ProgrammingElement to) {
        assert (from != null) : "from must not be null";
        assert (to != null) : "to must not be null";
        this.m_from = from;
        this.m_to = to;
    }

    final void replaceEndpoint(ProgrammingElement old, ProgrammingElement n) {
        assert (old != null) : "Parameter 'old' of method 'replaceEndpoint' must not be null";
        assert (n != null) : "Parameter 'n' of method 'replaceEndpoint' must not be null";
        if (this.m_from == old) {
            this.m_from = n;
        }
        if (this.m_to == old) {
            this.m_to = n;
        }
    }

    public final void remove() {
        if (this.m_from == this.m_to) {
            this.m_from.unlinkDependency(this);
        } else {
            this.m_from.unlinkDependency(this);
            this.m_to.unlinkDependency(this);
        }
        this.m_from = null;
        this.m_to = null;
    }

    @Override
    public final RefactoringState getRefactoringState() {
        return this.m_from.getCurrentModel().getRefactoringState(this);
    }

    @Override
    public boolean hasBeenDirectlyRefactored() {
        return this.hasIssues(IssueCategory.REFACTORING);
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    public Annotation getAnnotation() {
        return null;
    }

    public boolean isCompileTimeDependency() {
        return true;
    }

    public boolean includeInCycleAnalysis() {
        return this.isCompileTimeDependency();
    }

    public boolean isArchitectureRelevant() {
        return true;
    }

    private boolean hasArchitectureIssue(ArchitectureCheckIssueVisitor.Type type, IProviderId provider) {
        assert (type != null) : "Parameter 'type' of method 'hasArchitectureIssue' must not be null";
        if (this.isArchitectureRelevant() && !this.getRefactoringState().hasBeenDeleted()) {
            IVirtualModel currentVirtualModel = this.m_from.getCurrentModel();
            ArchitectureCheckIssueVisitor issueVisitor = new ArchitectureCheckIssueVisitor(type, provider);
            currentVirtualModel.accept(this, issueVisitor);
            return issueVisitor.hasIssue();
        }
        return false;
    }

    @Property
    public final boolean isViolation() {
        return this.hasArchitectureIssue(ArchitectureCheckIssueVisitor.Type.VIOLATION, null);
    }

    public final boolean isViolation(IProviderId provider) {
        assert (provider != null) : "Parameter 'provider' of method 'isViolation' must not be null";
        return this.hasArchitectureIssue(ArchitectureCheckIssueVisitor.Type.VIOLATION, provider);
    }

    @Property
    public final boolean isDeprecation() {
        return this.hasArchitectureIssue(ArchitectureCheckIssueVisitor.Type.DEPRECATION, null);
    }

    public final boolean isDeprecation(IProviderId provider) {
        assert (provider != null) : "Parameter 'provider' of method 'isViolation' must not be null";
        return this.hasArchitectureIssue(ArchitectureCheckIssueVisitor.Type.DEPRECATION, null);
    }

    @Override
    public final String getImageResourceName() {
        if (!this.isArchitectureRelevant()) {
            return "ArrowGrayRight";
        }
        if (this.isViolation()) {
            return "ViolatingParserDependency";
        }
        return ParserDependency.class.getSimpleName();
    }

    public final ProgrammingElement getOriginalFrom() {
        return this.m_from;
    }

    public final ProgrammingElement getOriginalTo() {
        return this.m_to;
    }

    @Override
    public final ProgrammingElement getFrom() {
        return this.m_from.getRepresentative();
    }

    @Override
    public final ProgrammingElement getTo() {
        return this.m_to != null ? this.m_to.getRepresentative() : null;
    }

    public final void setTo(ProgrammingElement to) {
        this.m_to = to;
    }

    @Override
    public final NamedElement getUnderlyingFrom() {
        return this.getFrom();
    }

    @Override
    public final NamedElement getUnderlyingTo() {
        return this.getTo();
    }

    @Override
    public final String getName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFrom().getName());
        builder.append(" -> ");
        ProgrammingElement to = this.getTo();
        builder.append(to != null ? to.getName() : "?");
        return builder.toString();
    }

    @Override
    public final String getShortName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFrom().getShortName());
        builder.append(" -> ");
        ProgrammingElement to = this.getTo();
        builder.append(to != null ? to.getShortName() : "?");
        return builder.toString();
    }

    @Override
    public final String getPresentationName(boolean shortName) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFrom().getPresentationName(shortName));
        builder.append(" -> ");
        ProgrammingElement to = this.getTo();
        builder.append(to != null ? to.getPresentationName(shortName) : "?");
        return builder.toString();
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this.m_from.getPropertiesManager();
    }

    @Override
    public final ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_from.getIssueManager();
    }

    @Override
    public final boolean isValid() {
        return this.m_to != null && this.m_to.isValid() && this.m_from.isValid();
    }

    @Override
    public int getLineNumber() {
        return this.m_from.getLineNumber();
    }

    @Override
    public final boolean isExcluded() {
        return this.m_from.isExcluded();
    }

    public abstract IParserDependencyType getDependencyType();

    public IParserDependencyContext getDependencyContext() {
        return null;
    }

    @Property
    public final IParserDependencyType getGenericDependencyType() {
        return this.getDependencyType().getGenericDependencyType();
    }

    @Property
    public final IParserDependencyContext getGenericDependencyContext() {
        IParserDependencyContext context = this.getDependencyContext();
        return context != null ? context.getGenericDependencyContext() : null;
    }

    public String getDescriptorContribution() {
        return "n/a";
    }

    @Override
    @Property
    public String getDependencyInfo() {
        return this.getDependencyType().getPresentationName();
    }

    @Property
    public String getDependencyInfoDescription() {
        IParserDependencyContext context = this.getDependencyContext();
        if (context != null) {
            return StringUtility.concat((char)',', (String[])new String[]{this.getDependencyType().getDescription(), context.getPresentationName(), context.getDescription()});
        }
        return this.getDependencyType().getDescription();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        assert (this.m_to != null) : "'m_to' of method 'store' must not be null";
        writer.write(this.m_to);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_to = reader.read(ProgrammingElement.class, new SnapshotArgument[0]);
        assert (this.m_to != null) : "'m_to' of method 'retrieve' must not be null";
    }

    public final boolean isEqual(ParserDependency other) {
        assert (other != null) : "Parameter 'other' of method 'isEqual' must not be null";
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (this.m_from != other.m_from) {
            return false;
        }
        if (this.m_to != other.m_to) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        return this.getDependencyType() == other.getDependencyType();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Info: ");
        builder.append(this.getDependencyInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Line: ");
        builder.append(this.getLineNumber());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Valid: ");
        builder.append(this.getFrom().isValid());
        builder.append(" -> ");
        ProgrammingElement to = this.getTo();
        builder.append(to != null ? Boolean.valueOf(to.isValid()) : "n/a");
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Defined in enclosing: ");
        builder.append(this.getFrom().isDefinedInEnclosingElement());
        builder.append(" -> ");
        builder.append(to != null ? Boolean.valueOf(to.isDefinedInEnclosingElement()) : "n/a");
        Annotation annotation = this.getAnnotation();
        if (annotation != null) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(annotation.getDebugInfo());
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\nDependency info: ").append(this.getDependencyInfo());
        builder.append("\nFrom:\n").append(this.m_from).append("\n->\n");
        builder.append("To:\n");
        if (this.m_to != null) {
            builder.append(this.m_to);
        } else {
            builder.append("<null>");
        }
        return builder.toString();
    }
}

