/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IElement;
import com.hello2morrow.sonargraph.core.model.programming.ILogicalProgrammingElementOwner;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LogicalProgrammingElementHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicalProgrammingElementHelper.class);

    private LogicalProgrammingElementHelper() {
    }

    static void createDirectChildren(List<ProgrammingElement> programmingElements, ILogicalProgrammingElementOwner owner) {
        assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'createDirectChildren' must not be empty";
        assert (owner != null) : "Parameter 'owner' of method 'createDirectChildren' must not be null";
        THashMap fqNamePartToCounter = new THashMap();
        for (ProgrammingElement next : programmingElements) {
            Object nextFqNamePart = next.getFullyQualifiedNamePart();
            Integer nextCounter = (Integer)fqNamePartToCounter.get(nextFqNamePart);
            if (nextCounter == null) {
                nextCounter = 1;
                fqNamePartToCounter.put(nextFqNamePart, nextCounter);
            } else {
                LOGGER.debug("Element with '" + (String)nextFqNamePart + "' already added underneath: " + owner.getNamedElement().getFullyQualifiedName() + " [" + owner.getClass().getName() + "] - creating new fq name part");
                nextFqNamePart = (String)nextFqNamePart + IElement.INNER_NAME_PARTS_SEPARATOR + nextCounter.toString();
                nextCounter = nextCounter + 1;
                fqNamePartToCounter.put(nextFqNamePart, nextCounter);
            }
            owner.addLogicalProgrammingElement(Collections.singletonList(next), (String)nextFqNamePart);
        }
    }
}

