/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.plugin;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.DynamicIssueWithDescription;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import java.io.IOException;

public final class PluginElementIssue
extends DynamicIssueWithDescription {
    private static final String LINE = "line";
    private static final String ID = "id";
    private PluginIssueId m_id;
    private int m_line;

    public PluginElementIssue() {
    }

    public PluginElementIssue(PluginIssueId id, NamedElement element, String description, int line) {
        super(element, description);
        assert (id != null) : "Parameter 'id' of method 'PluginElementIssue' must not be null";
        assert (IIssueId.PatternEditMode.ELEMENT.equals((Object)id.getPatternEditMode()));
        this.m_id = id;
        this.m_line = line;
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeOther(ID, (Object)this.m_id);
        writer.writeInt(LINE, this.m_line);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readOther(ID, PluginIssueId.class, id -> {
            PluginIssueId pluginIssueId = this.m_id = id;
        });
        this.m_line = reader.readInt(LINE);
    }

    @Override
    public IIssueId getId() {
        return this.m_id;
    }

    @Override
    public String getKey() {
        return super.getKey() + ":" + this.getProvider().getStandardName();
    }

    @Override
    public int getLineNumber() {
        return this.m_line <= 0 ? super.getLineNumber() : this.m_line;
    }

    @Override
    public IProviderId getProvider() {
        return this.m_id.getProvider();
    }
}

