/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class QualityModel {
    private final List<IModifiableFile> m_availableFiles;

    protected static final Comparator<IModifiableFile> getModifiableFileComparator() {
        return new Comparator<IModifiableFile>(){

            @Override
            public int compare(IModifiableFile m1, IModifiableFile m2) {
                if (!$assertionsDisabled && m1 == null) {
                    throw new AssertionError((Object)"Parameter 'm1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && m2 == null) {
                    throw new AssertionError((Object)"Parameter 'm2' of method 'compare' must not be null");
                }
                int compared = m1.getFileType().getStandardName().compareTo(m2.getFileType().getStandardName());
                if (compared == 0) {
                    compared = m1.getIdentifyingPath().compareTo(m2.getIdentifyingPath());
                }
                return compared;
            }
        };
    }

    public QualityModel(List<IModifiableFile> availableFiles) {
        assert (availableFiles != null) : "Parameter 'availableFiles' of method 'QualityModel' must not be null";
        this.m_availableFiles = new ArrayList<IModifiableFile>(availableFiles);
        Collections.sort(this.m_availableFiles, QualityModel.getModifiableFileComparator());
    }

    public QualityModel() {
        this.m_availableFiles = Collections.emptyList();
    }

    protected final List<IModifiableFile> getAvailableModifiableFiles() {
        return Collections.unmodifiableList(this.m_availableFiles);
    }
}

