/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public enum MetricCategory implements IMetricCategory
{
    ARCHITECTURE("Architecture", 0),
    CODE_ANALYSIS("Code Analysis", 1),
    CYCLE("Cycle", 2),
    COHESION_AND_COUPLING("Cohesion/Coupling", 3),
    DEPENDENCY("Dependency", 4),
    SIZE("Size", 5),
    TASK_FILTER("Task & Filter", 6),
    JOHN_LAKOS("John Lakos", 7),
    CRAIG_LARMAN("Craig Larman", 8),
    ROBERT_MARTIN("Robert C. Martin", 9),
    THOMAS_MCCABE("Thomas J. McCabe", 10),
    MAC_CORMACK("MacCormack, Rusnak, Baldwin", 11),
    CHANGE_HISTORY("Change History", 12),
    COMPLEXITY("Complexity", 13);

    private final String m_presentationName;
    private final int m_orderNumber;

    private MetricCategory(String presentationName, int orderNumber) {
        this.m_presentationName = presentationName;
        this.m_orderNumber = orderNumber;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    @Override
    public int getOrderNumber() {
        return this.m_orderNumber;
    }
}

