/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.issuehierarchy;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueCountInfo;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class IssueNamedElement
extends NamedElementContainer {
    private final IssueCountInfo m_aggregatedIssueInfo = new IssueCountInfo();
    private ArrayList<Issue> m_ownIssues;

    protected IssueNamedElement(NamedElement parent) {
        super(parent);
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public final void addIssueAsInfo(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addIssue' must not be null";
        if (this.m_ownIssues == null) {
            this.m_ownIssues = new ArrayList();
            this.m_ownIssues.add(issue);
        } else if (!this.m_ownIssues.contains(issue)) {
            this.m_ownIssues.add(issue);
        }
    }

    public final List<Issue> getIssuesAsList() {
        return this.m_ownIssues == null ? Collections.emptyList() : this.m_ownIssues;
    }

    public final List<Issue> getIssuesRecursively() {
        LinkedHashSet<Issue> allIssues = new LinkedHashSet<Issue>();
        this.collectIssuesRecursively(allIssues);
        return Collections.unmodifiableList(new ArrayList<Issue>(allIssues));
    }

    private void collectIssuesRecursively(Set<Issue> collector) {
        collector.addAll(this.getIssuesAsList());
        for (IssueNamedElement next : this.getChildren(IssueNamedElement.class)) {
            next.collectIssuesRecursively(collector);
        }
    }

    public static final List<Issue> getIssuesRecursively(List<IssueNamedElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getIssuesRecursively' must not be empty";
        ArrayList<IssueNamedElement> localCopy = new ArrayList<IssueNamedElement>(elements);
        Iterator iter = localCopy.iterator();
        while (iter.hasNext()) {
            IssueNamedElement next = (IssueNamedElement)iter.next();
            List<IssueNamedElement> hierarchy = IssueNamedElement.getHierarchy(next);
            hierarchy.retainAll(elements);
            if (hierarchy.isEmpty()) continue;
            iter.remove();
        }
        assert (!localCopy.isEmpty()) : "List of elements must not be empty";
        LinkedHashSet<Issue> allIssues = new LinkedHashSet<Issue>();
        for (IssueNamedElement next : localCopy) {
            next.collectIssuesRecursively(allIssues);
        }
        return Collections.unmodifiableList(new ArrayList(allIssues));
    }

    public static final List<IssueNamedElement> getHierarchy(IssueNamedElement element) {
        assert (element != null) : "Parameter 'node' of method 'getHierarchy' must not be null";
        ArrayList<IssueNamedElement> parents = new ArrayList<IssueNamedElement>();
        IssueNamedElement parent = element.getParent(IssueNamedElement.class, ParentMode.ONLY_DIRECT_PARENT);
        if (parent != null) {
            parents.add(parent);
            parents.addAll(IssueNamedElement.getHierarchy(parent));
        }
        return parents;
    }

    public final IssueCountInfo getIssueInfo() {
        return this.m_aggregatedIssueInfo;
    }

    final List<Issue> getOwnIssues() {
        return this.m_ownIssues == null ? Collections.emptyList() : this.m_ownIssues;
    }

    @Override
    public void finishModification() {
        if (this.m_ownIssues != null) {
            this.m_ownIssues.trimToSize();
        }
        super.finishModification();
    }

    public static interface IIssueNamedElementVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitIssueNamedElement(IssueNamedElement var1);
    }
}

