/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.filter;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import java.util.List;

public abstract class Filter
extends NamedElementContainer {
    private boolean m_hasPatterns;

    public static final boolean areEqual(Filter filter1, Filter filter2) {
        assert (filter1 != null) : "Parameter 'filter1' of method 'areEqual' must not be null";
        assert (filter2 != null) : "Parameter 'filter2' of method 'areEqual' must not be null";
        List<WildcardPattern> patternList1 = filter1.getChildren(WildcardPattern.class);
        List<WildcardPattern> patternList2 = filter2.getChildren(WildcardPattern.class);
        if (patternList1.size() != patternList2.size()) {
            return false;
        }
        int i = 0;
        while (i < patternList1.size()) {
            if (!patternList1.get(i).getName().equals(patternList2.get(i).getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Filter(NamedElement parent) {
        super(parent);
    }

    @Override
    public final String fullyQualifiedName() {
        return null;
    }

    @Override
    public String getImageResourceName() {
        return Filter.class.getSimpleName();
    }

    @Override
    public final void addChild(NamedElement child) {
        assert (child instanceof WildcardPattern) : "Not a wildcard pattern element: " + String.valueOf(child);
        this.m_hasPatterns = true;
        super.addChild(child);
    }

    @Override
    protected final void lastChildRemoved() {
        this.m_hasPatterns = false;
        super.lastChildRemoved();
    }

    public final boolean hasPatterns() {
        return this.m_hasPatterns;
    }

    protected final boolean include(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'include' must not be empty";
        if (!this.m_hasPatterns) {
            return true;
        }
        boolean include = false;
        List<WildcardPatternInclude> includes = this.getChildren(WildcardPatternInclude.class);
        if (includes.isEmpty()) {
            include = true;
        } else {
            for (WildcardPatternInclude nextInclude : includes) {
                if (!nextInclude.matches(name)) continue;
                include = true;
                break;
            }
        }
        if (include) {
            List<WildcardPatternExclude> excludes = this.getChildren(WildcardPatternExclude.class);
            for (WildcardPatternExclude nextExclude : excludes) {
                if (!nextExclude.matches(name)) continue;
                include = false;
                break;
            }
        }
        return include;
    }

    public void initialize() {
        this.getChildren(WildcardPattern.class).forEach(p -> p.initialize());
    }

    public void clear() {
        this.getChildren(WildcardPattern.class).forEach(p -> p.clear());
    }

    @Override
    public final void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
    }

    public abstract boolean invalidatesParserModel();

    @Override
    public abstract boolean persist(ISnapshotProcessor.Mode var1);

    @Override
    public abstract String getInformation();

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        for (WildcardPatternInclude wildcardPatternInclude : this.getChildren(WildcardPatternInclude.class)) {
            builder.append("\n").append("Include: ").append(wildcardPatternInclude.getName());
        }
        for (WildcardPatternExclude wildcardPatternExclude : this.getChildren(WildcardPatternExclude.class)) {
            builder.append("\n").append("Exclude: ").append(wildcardPatternExclude.getName());
        }
        return builder.toString();
    }
}

