/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.util.Collections;
import java.util.List;

public final class RevealRequest {
    private final ExplorationViewRepresentation m_representation;
    private final List<ArchitecturalViewNode> m_nodes;
    private final ExplorationViewFocusProperties m_properties;

    public RevealRequest(ExplorationViewRepresentation representation, List<ArchitecturalViewNode> nodes, ExplorationViewFocusProperties properties) {
        assert (representation != null) : "Parameter 'representation' of method 'RevealRequest' must not be null";
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'RevealRequest' must not be empty";
        this.m_representation = representation;
        this.m_nodes = nodes;
        this.m_properties = properties;
    }

    public ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    public ExplorationViewFocusProperties getFocusProperties() {
        return this.m_properties;
    }

    public List<ArchitecturalViewNode> getNodes() {
        List<ArchitecturalViewNode> partialAlternative = this.m_properties != null ? this.m_properties.getPartialAlternative() : null;
        return partialAlternative != null ? partialAlternative : Collections.unmodifiableList(this.m_nodes);
    }
}

