/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;

public final class MovableTargetInfo {
    private final ArchitecturalViewElement m_target;
    private final int m_relativeIndex;

    public MovableTargetInfo(ArchitecturalViewElement target, int relativeIndex) {
        assert (target != null) : "Parameter 'target' of method 'MovableTargetInfo' must not be null";
        assert (relativeIndex >= -1) : "Invalid 'relativeIndex' in method 'MovableTargetInfo': " + relativeIndex;
        this.m_target = target;
        this.m_relativeIndex = relativeIndex;
    }

    public ArchitecturalViewElement getTarget() {
        return this.m_target;
    }

    public int getRelativeIndex() {
        return this.m_relativeIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_target.hashCode();
        result = 31 * result + this.m_relativeIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MovableTargetInfo other = (MovableTargetInfo)obj;
        return this.m_target == other.m_target && this.m_relativeIndex == other.m_relativeIndex;
    }

    public String toString() {
        return "[" + this.m_target.getClass().getSimpleName() + "] " + this.m_target.getName() + " at pos " + this.m_relativeIndex;
    }
}

