/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IssueList {
    private final IIssueFilter m_filter;
    private final List<Issue> m_issues = new ArrayList<Issue>();
    private int m_errors;
    private int m_warnings;
    private int m_info;
    private int m_none;

    public IssueList(IIssueFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'enclosing_method' must not be null";
        this.m_filter = filter;
    }

    public IIssueFilter getIssueFilter() {
        return this.m_filter;
    }

    private void countIssue(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addIssue' must not be null";
        switch (issue.getSeverity()) {
            case ERROR: {
                ++this.m_errors;
                break;
            }
            case WARNING: {
                ++this.m_warnings;
                break;
            }
            case INFO: {
                ++this.m_info;
                break;
            }
            case NONE: {
                ++this.m_none;
                break;
            }
            default: {
                assert (false) : "Unhandled severity: " + String.valueOf((Object)issue.getSeverity());
                break;
            }
        }
    }

    public final boolean isEmpty() {
        return this.m_errors == 0 && this.m_warnings == 0 && this.m_info == 0 && this.m_none == 0;
    }

    public final int getNumberOfIssues() {
        return this.m_errors + this.m_warnings + this.m_info + this.m_none;
    }

    public final int getNumberOfSeverityErrorIssues() {
        return this.m_errors;
    }

    public final int getNumberOfSeverityWarningIssues() {
        return this.m_warnings;
    }

    public final int getNumberOfSeverityInfoIssues() {
        return this.m_info;
    }

    public final int getNumberOfSeverityNoneIssues() {
        return this.m_none;
    }

    public void processIssue(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'processIssue' must not be null";
        if (this.m_filter.accept(issue)) {
            this.m_issues.add(issue);
            this.countIssue(issue);
        }
    }

    public List<Issue> getIssues() {
        return Collections.unmodifiableList(this.m_issues);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Contains ");
        builder.append(this.m_issues.size());
        builder.append(" issue(s)");
        for (Issue issue : this.m_issues) {
            builder.append("\n");
            builder.append((Object)issue.getSeverity());
            builder.append(": ");
            builder.append(issue.getDescription());
            builder.append(" [");
            builder.append(issue.getClass().getName());
            builder.append("]");
        }
        return builder.toString();
    }
}

