/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.common;

import java.util.Arrays;

public final class SourceLineWithContext {
    private final String[] m_context;
    private final int m_lineNumber;
    private final int m_linePosition;

    public SourceLineWithContext(String[] context, int linePosition, int lineNumber) {
        assert (context != null && context.length > 0) : "Parameter 'context' of method 'SourceLine' must not be empty";
        assert (linePosition >= 0 && linePosition < context.length) : "Parameter 'linePosition' " + linePosition + " is not within range of context 0 - " + (context.length - 1);
        assert (lineNumber > 0) : "Line number must be positive, but was " + lineNumber;
        this.m_context = context;
        this.m_linePosition = linePosition;
        this.m_lineNumber = lineNumber;
    }

    public String toString() {
        return this.m_context[this.m_linePosition] + ", line: " + this.m_lineNumber;
    }

    public String getText() {
        return this.m_context[this.m_linePosition];
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public String[] getPrefix() {
        if (this.m_linePosition == 0) {
            return new String[0];
        }
        return Arrays.copyOfRange(this.m_context, 0, this.m_linePosition);
    }

    public String[] getPostfix() {
        if (this.m_linePosition == this.m_context.length - 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(this.m_context, this.m_linePosition + 1, this.m_context.length);
    }
}

