/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.common;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.List;

public final class IssueCategory
extends Enum<IssueCategory>
implements IStandardEnumeration {
    public static final /* enum */ IssueCategory INSTALLATION_CONFIGURATION = new IssueCategory(false);
    public static final /* enum */ IssueCategory SYSTEM_CONFIGURATION = new IssueCategory(false);
    public static final /* enum */ IssueCategory WORKSPACE = new IssueCategory(false);
    public static final /* enum */ IssueCategory THRESHOLD_VIOLATION = new IssueCategory(false);
    public static final /* enum */ IssueCategory CYCLE_GROUP = new IssueCategory(false);
    public static final /* enum */ IssueCategory DUPLICATE_CODE = new IssueCategory(false);
    public static final /* enum */ IssueCategory REFACTORING = new IssueCategory(true);
    public static final /* enum */ IssueCategory TODO = new IssueCategory(true);
    public static final /* enum */ IssueCategory SCRIPT_DEFINITION = new IssueCategory(false);
    public static final /* enum */ IssueCategory SCRIPT_BASED = new IssueCategory(false);
    public static final /* enum */ IssueCategory ARCHITECTURE_DEFINITION = new IssueCategory(false);
    public static final /* enum */ IssueCategory ARCHITECTURE_CONSISTENCY = new IssueCategory(false);
    public static final /* enum */ IssueCategory ARCHITECTURE_VIOLATION = new IssueCategory(false);
    public static final /* enum */ IssueCategory ARCHITECTURE_DEPRECATION = new IssueCategory(false);
    public static final /* enum */ IssueCategory ARCHITECTURAL_VIEW = new IssueCategory(false);
    public static final /* enum */ IssueCategory PLUGIN_BASED = new IssueCategory(false);
    public static final /* enum */ IssueCategory QUALITY_GATE = new IssueCategory(false);
    private final String m_standardName = StringUtility.convertConstantNameToStandardName((String)this.name());
    private final String m_presentationName = StringUtility.convertConstantNameToPresentationName((String)this.name());
    private final boolean m_generated;
    private static final /* synthetic */ IssueCategory[] ENUM$VALUES;

    static {
        ENUM$VALUES = new IssueCategory[]{INSTALLATION_CONFIGURATION, SYSTEM_CONFIGURATION, WORKSPACE, THRESHOLD_VIOLATION, CYCLE_GROUP, DUPLICATE_CODE, REFACTORING, TODO, SCRIPT_DEFINITION, SCRIPT_BASED, ARCHITECTURE_DEFINITION, ARCHITECTURE_CONSISTENCY, ARCHITECTURE_VIOLATION, ARCHITECTURE_DEPRECATION, ARCHITECTURAL_VIEW, PLUGIN_BASED, QUALITY_GATE};
    }

    private IssueCategory(boolean generated) {
        this.m_generated = generated;
    }

    public static IssueCategory fromStandardName(String standardName) throws IllegalArgumentException {
        assert (standardName != null) : "'standardName' must not be null";
        assert (standardName.length() > 0) : "'standardName' must not be empty";
        String name = StringUtility.convertStandardNameToConstantName((String)standardName);
        return IssueCategory.valueOf(name);
    }

    public static List<IssueCategory> getNonGeneratedIssueCategories() {
        IssueCategory[] allCategories = IssueCategory.values();
        ArrayList<IssueCategory> categories = new ArrayList<IssueCategory>(allCategories.length);
        IssueCategory[] issueCategoryArray = allCategories;
        int n = allCategories.length;
        int n2 = 0;
        while (n2 < n) {
            IssueCategory nextCategory = issueCategoryArray[n2];
            if (!nextCategory.isGenerated()) {
                categories.add(nextCategory);
            }
            ++n2;
        }
        return categories;
    }

    public boolean isGenerated() {
        return this.m_generated;
    }

    public String getStandardName() {
        return this.m_standardName;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public static IssueCategory[] values() {
        IssueCategory[] issueCategoryArray = ENUM$VALUES;
        int n = issueCategoryArray.length;
        IssueCategory[] issueCategoryArray2 = new IssueCategory[n];
        System.arraycopy(ENUM$VALUES, 0, issueCategoryArray2, 0, n);
        return issueCategoryArray2;
    }

    public static IssueCategory valueOf(String string) {
        return Enum.valueOf(IssueCategory.class, string);
    }
}

