/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.common;

import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import java.util.List;

public interface IIssueId
extends IStandardEnumeration {
    public IssueCategory getCategory();

    public List<Severity> getSupportedSeverities();

    public PatternEditMode getPatternEditMode();

    default public String getInformation() {
        return "";
    }

    default public boolean isResolvable() {
        return true;
    }

    default public boolean isDynamic() {
        return false;
    }

    default public boolean previewOnly() {
        return false;
    }

    public boolean isParserModelIssue();

    default public boolean persist() {
        return this.isParserModelIssue();
    }

    default public boolean requiresIndividualResolution() {
        return false;
    }

    default public String getDebugInfo() {
        return this.getStandardName() + " [" + Integer.toHexString(this.hashCode()) + "]";
    }

    public String getProviderName();

    default public String getQualifiedName() {
        StringBuilder stringBuilder = new StringBuilder(this.getProviderName());
        stringBuilder.append(":").append(this.getStandardName());
        return stringBuilder.toString();
    }

    public static enum PatternEditMode {
        ELEMENT,
        DEPENDENCY,
        ELEMENT_AND_DEPENDENCY,
        UNEDITABLE;

    }
}

