/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ElementAssignmentInfo {
    private final List<ArchitectureBaseElement> m_elements = new ArrayList<ArchitectureBaseElement>();
    private final IAssignableToArtifact m_assignable;
    private final IArchitecturalModelProvider.ArchitectureModel m_model;

    public ElementAssignmentInfo(IAssignableToArtifact assignable, IArchitecturalModelProvider.ArchitectureModel model) {
        assert (assignable != null) : "Parameter 'assignable' of method 'ComponentArchitectureAssignmentInfo' must not be null";
        assert (model != null) : "Parameter 'model' of method 'ElementAssignmentInfo' must not be null";
        this.m_assignable = assignable;
        this.m_model = model;
    }

    public IArchitecturalModelProvider.ArchitectureModel getModel() {
        return this.m_model;
    }

    public IAssignableToArtifact getAssignable() {
        return this.m_assignable;
    }

    public void add(ArchitectureBaseElement element) {
        assert (element != null) : "Parameter 'element' of method 'add' must not be null";
        assert (!this.m_elements.contains(element)) : "Already added: " + String.valueOf(element);
        this.m_elements.add(element);
    }

    public boolean isEmpty() {
        return this.m_elements.isEmpty();
    }

    public List<ArchitectureBaseElement> getElements() {
        return Collections.unmodifiableList(this.m_elements);
    }

    public String getAssignedToInfo(ArchitectureBaseElement element) {
        assert (element != null) : "Parameter 'element' of method 'getAssignedTo' must not be null";
        assert (this.m_elements.contains(element)) : "Element not present: " + String.valueOf(element);
        ArchitectureFile architectureFile = element.getParent(ArchitectureFile.class, new Class[0]);
        if (architectureFile != null) {
            String kind = element.getPresentationKind();
            return architectureFile.getIdentifyingPath() + "/" + element.getName() + " (" + kind + ")";
        }
        assert (element != null && element instanceof UnassignedElements) : "Unexpected class in method 'getAssignedToInfo': " + String.valueOf(element);
        return element.getName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.m_assignable.getNamedElement().getName());
        if (!this.isEmpty()) {
            builder.append(" <").append(this.m_elements.size()).append(">");
            builder.append(StringUtility.DEFAULT_LINE_SEPARATOR);
            for (ArchitectureBaseElement next : this.m_elements) {
                ArchitectureFile architectureFile = next.getParent(ArchitectureFile.class, new Class[0]);
                if (architectureFile != null) {
                    builder.append("Assigned to file/" + next.getPresentationKind() + ": ").append(architectureFile.getIdentifyingPath()).append("/").append(next.getName());
                } else {
                    assert (next instanceof UnassignedElements) : "Unexpected class in method 'toString': " + String.valueOf(next);
                    builder.append(next.getName());
                }
                builder.append(StringUtility.DEFAULT_LINE_SEPARATOR);
            }
        } else {
            builder.append(" ").append("<no assignment info>");
        }
        return builder.toString();
    }
}

