/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.annotation;

import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import java.io.IOException;

public final class EnumAnnotationValue
extends AnnotationValue
implements AnnotationValue.IEnumAnnotation,
ISnapshotWriter.IWriteStorableContext {
    private String m_enumString;
    private NamedElement m_enumConstant;
    private int m_lineNumber;

    public EnumAnnotationValue() {
    }

    public EnumAnnotationValue(String enumString, int lineNumber) {
        assert (enumString != null && enumString.length() > 0) : "Parameter 'enumString' of method 'EnumAnnotationValue' must not be empty";
        this.m_enumString = enumString;
        this.m_lineNumber = lineNumber;
    }

    @Override
    public void removeInvalidElementReference() {
        if (this.m_enumConstant != null && !this.m_enumConstant.isValid()) {
            this.m_enumConstant = null;
        }
    }

    @Override
    public NamedElement getReferencedElement() {
        return this.m_enumConstant;
    }

    @Override
    public NamedElement getEnumConstant() {
        return this.m_enumConstant;
    }

    public void setEnumConstant(NamedElement enumConstant) {
        this.m_enumConstant = enumConstant;
    }

    @Override
    public String getEnumString() {
        return this.m_enumString;
    }

    @Override
    public String getEnumFieldName() {
        if (this.m_enumConstant != null) {
            return this.m_enumConstant.getShortName();
        }
        int dot = this.m_enumString.lastIndexOf(46);
        if (dot > 0) {
            return this.m_enumString.substring(dot + 1);
        }
        return this.m_enumString;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    @Override
    public AnnotationValue.IEnumAnnotation asEnumConstant() {
        return this;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        assert (reader != null) : "Parameter 'reader' of method 'retrieve' must not be null";
        this.m_enumString = reader.readString();
        this.m_enumConstant = reader.read(NamedElement.class, new SnapshotArgument[0]);
        this.m_lineNumber = reader.readInt();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        assert (writer != null) : "Parameter 'writer' of method 'store' must not be null";
        writer.writeString(this.m_enumString);
        writer.write(this.m_enumConstant, this);
        writer.writeInt(this.m_lineNumber);
    }

    @Override
    public void addDiagnosticInfo(StringBuilder builder) {
        assert (builder != null) : "Parameter 'builder' of method 'addDiagnosticInfo' must not be null";
        builder.append("Enum Constant: ").append(this.m_enumString).append("\n");
    }

    @Override
    public void accept(AnnotationValue.AnnotationVisitor v) {
        if (v instanceof IVisitor) {
            ((IVisitor)((Object)v)).visitEnumAnnotationValue(this);
        } else {
            super.accept(v);
        }
    }

    public String toString() {
        return this.m_enumString;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        builder.append("Enum constant name: ");
        builder.append(this.m_enumString);
        builder.append(" [");
        if (this.m_enumConstant == null) {
            builder.append("null");
        } else if (!this.m_enumConstant.isValid()) {
            builder.append("reference not valid");
        } else {
            builder.append("reference is valid - full name: ").append(this.m_enumConstant.getName());
        }
        builder.append("]");
        return builder.toString();
    }

    public static interface IVisitor {
        public void visitEnumAnnotationValue(EnumAnnotationValue var1);
    }
}

