/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.CycleGroupKind;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import java.io.IOException;

public final class LogicalNamespaceCycleGroup
extends AnalyzerCycleGroup {
    private static final String LANGUAGE = "language";
    public static final IIssueId ISSUE_ID = CoreIssueId.NAMESPACE_CYCLE_GROUP;
    private Language m_language;

    public LogicalNamespaceCycleGroup(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeOther(LANGUAGE, (Object)this.m_language);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readOther(LANGUAGE, Language.class, l -> {
            Language language = this.m_language = l;
        });
    }

    public LogicalNamespaceCycleGroup(NamedElement parent, NamedElement scope, Language language, boolean isCritical) {
        super(parent, scope, isCritical);
        assert (language != null) : "Parameter 'language' of method 'NamespaceCycleGroup' must not be null";
        this.m_language = language;
    }

    @Override
    public String getDescription() {
        return this.getNumberOfCyclicElements() + " cyclic " + this.m_language.getNamespacePresentationName().toLowerCase() + "s";
    }

    @Override
    public String getPresentationKind() {
        return this.m_language.getNamespacePresentationName() + " cycle group";
    }

    @Override
    public IIssueId getCycleGroupIssueId() {
        return ISSUE_ID;
    }

    @Override
    public CycleGroupKind getKind() {
        return CycleGroupKind.PACKAGE_OR_NAMESPACE_CYCLES;
    }
}

