/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.IConnectedNodeRunnerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.NodeIndexBasedCalculator;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.set.hash.THashSet;
import java.util.BitSet;
import java.util.Collection;

public final class ConnectedNodeRunner
extends NodeIndexBasedCalculator {
    private final IConnectedNodeRunnerAdapter m_adapter;
    private final BitSet m_seen;

    public ConnectedNodeRunner(Collection<? extends INode<?>> nodes, IWorkerContext workerContext, IConnectedNodeRunnerAdapter adapter) {
        super(nodes, workerContext, 0);
        assert (adapter != null) : "Parameter 'adapter' of method 'ConnectedNodeRunner' must not be null";
        this.m_adapter = adapter;
        this.m_seen = new BitSet(this.m_numberOfNodes);
        Collection<INode<?>> startNodes = this.m_adapter.getStartNodes();
        THashSet currentLevel = new THashSet(startNodes.size());
        THashSet nextLevel = new THashSet();
        for (INode<?> iNode : startNodes) {
            currentLevel.add(iNode);
        }
        switch (this.m_adapter.getMode()) {
            case IN: {
                while (!currentLevel.isEmpty()) {
                    this.m_adapter.aboutToProcessLevel((Collection<INode<?>>)currentLevel);
                    for (INode<Object> iNode : currentLevel) {
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return;
                        }
                        int nodeIndex = this.getIndex(iNode);
                        if (this.m_seen.get(nodeIndex)) continue;
                        this.m_seen.set(nodeIndex, true);
                        if (!this.m_adapter.visitConnectedNode(iNode)) continue;
                        for (INode.IEdge nextIncoming : iNode.getIncomingEdges()) {
                            nextLevel.add(nextIncoming.getFrom());
                        }
                    }
                    currentLevel = nextLevel;
                    nextLevel = new THashSet();
                }
                break;
            }
            case OUT: {
                while (!currentLevel.isEmpty()) {
                    this.m_adapter.aboutToProcessLevel((Collection<INode<?>>)currentLevel);
                    for (INode<Object> iNode : currentLevel) {
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return;
                        }
                        int nodeIndex = this.getIndex(iNode);
                        if (this.m_seen.get(nodeIndex)) continue;
                        this.m_seen.set(nodeIndex, true);
                        if (!this.m_adapter.visitConnectedNode(iNode)) continue;
                        for (INode.IEdge nextIncoming : iNode.getOutgoingEdges()) {
                            nextLevel.add(nextIncoming.getTo());
                        }
                    }
                    currentLevel = nextLevel;
                    nextLevel = new THashSet();
                }
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_adapter.getMode());
                break;
            }
        }
    }
}

