/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class AdjacencyGraph<T> {
    private final Map<T, Set<T>> m_successors = new LinkedHashMap<T, Set<T>>();
    private boolean m_transitiveHullComputed;

    public AdjacencyGraph(Map<T, Set<T>> mapToSet) {
        assert (mapToSet != null) : "Parameter 'mapToSet' of method 'AdjacencyGraph' must not be null";
        for (Map.Entry<T, Set<T>> entry : mapToSet.entrySet()) {
            this.m_successors.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
    }

    public void transitiveHull() {
        LinkedHashSet<T> ready = new LinkedHashSet<T>();
        for (T x : this.m_successors.keySet()) {
            Set result = this.transitiveFollowers(x, ready);
            this.m_successors.put(x, result);
            ready.add(x);
        }
    }

    public Set<T> transitiveFollowers(Object x) {
        return this.transitiveFollowers(x, new LinkedHashSet());
    }

    private Set<T> transitiveFollowers(Object x, Set<T> ready) {
        Set<T> succOfX = this.m_successors.get(x);
        if (succOfX == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        result.addAll(succOfX);
        Set<T> elementsToCheck = succOfX;
        while (!elementsToCheck.isEmpty()) {
            LinkedHashSet<T> nextElementsToAddAndCheck = new LinkedHashSet<T>();
            LinkedHashSet<T> nextElementsToAdd = new LinkedHashSet<T>();
            for (T succ : elementsToCheck) {
                boolean succIsReady = ready.contains(succ);
                Set<T> successorsOfSucc = this.m_successors.get(succ);
                if (successorsOfSucc == null) continue;
                for (T t : successorsOfSucc) {
                    if (result.contains(t)) continue;
                    if (succIsReady) {
                        nextElementsToAdd.add(t);
                        continue;
                    }
                    nextElementsToAddAndCheck.add(t);
                }
            }
            result.addAll(nextElementsToAddAndCheck);
            result.addAll(nextElementsToAdd);
            elementsToCheck = nextElementsToAddAndCheck;
        }
        return result;
    }

    public Map<T, Set<T>> getTransitiveHull() {
        if (!this.m_transitiveHullComputed) {
            this.m_transitiveHullComputed = true;
            this.transitiveHull();
        }
        return this.m_successors;
    }
}

