/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.LocationWithLogicalLineNumber;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.ArrayList;
import java.util.Arrays;

final class FileContent
implements LocationWithLogicalLineNumber.IFileContent {
    private static final int INCREMENT = 100;
    private final IFile m_file;
    private final ArrayList<byte[]> m_hashes = new ArrayList();
    private int[] m_physicalLines = new int[100];
    private int m_idx = 0;
    private int[] m_lineHashCodes = new int[100];

    FileContent(IFile file) {
        assert (file != null) : "Parameter 'file' of method 'FileContent' must not be null";
        this.m_file = file;
    }

    @Override
    public IFile getFile() {
        return this.m_file;
    }

    void addHashLine(byte[] hash, int physicalLine, int hashCode) {
        this.m_hashes.add(hash);
        if (this.m_idx == this.m_physicalLines.length) {
            int[] scratch = new int[this.m_physicalLines.length + 100];
            System.arraycopy(this.m_physicalLines, 0, scratch, 0, this.m_idx);
            this.m_physicalLines = scratch;
            int[] scratch2 = new int[this.m_lineHashCodes.length + 100];
            System.arraycopy(this.m_lineHashCodes, 0, scratch2, 0, this.m_idx);
            this.m_lineHashCodes = scratch2;
        }
        this.m_lineHashCodes[this.m_idx] = hashCode;
        this.m_physicalLines[this.m_idx++] = physicalLine;
    }

    @Override
    public byte[] getHashForLogicalLineNumber(int logicalPosition) {
        return this.m_hashes.get(logicalPosition);
    }

    @Override
    public StrictPair<String, IntBasedHash> getHash(int fromLinePhysical, int toLinePhysical) {
        int fromLineLogical = -1;
        int toLineLogical = -1;
        int i = 0;
        while (i < this.m_physicalLines.length) {
            int nextPhysicalLine = this.m_physicalLines[i];
            if (fromLineLogical == -1 && nextPhysicalLine == fromLinePhysical) {
                fromLineLogical = i;
            }
            if (toLineLogical == -1 && nextPhysicalLine == toLinePhysical) {
                toLineLogical = i;
            }
            if (fromLineLogical != -1 && toLineLogical != -1) break;
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        int i2 = fromLineLogical;
        while (i2 <= toLineLogical) {
            byte[] byArray = this.m_hashes.get(i2);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte nextByte = byArray[n2];
                builder.append(nextByte);
                ++n2;
            }
            ++i2;
        }
        int[] lineHashCodes = Arrays.copyOfRange(this.m_lineHashCodes, fromLineLogical, toLineLogical + 1);
        return new StrictPair((Object)builder.toString(), (Object)new IntBasedHash(lineHashCodes));
    }

    @Override
    public LocationWithLogicalLineNumber createLocation(int logicalLineNumber) {
        return new LocationWithLogicalLineNumber(this, this.m_physicalLines[logicalLineNumber], logicalLineNumber);
    }

    @Override
    public int numberOfLogicalPositions() {
        return this.m_idx;
    }

    public void trimToSize() {
        this.m_hashes.trimToSize();
        int[] scratch = new int[this.m_idx];
        System.arraycopy(this.m_physicalLines, 0, scratch, 0, this.m_idx);
        this.m_physicalLines = scratch;
    }

    int createLogicalLineNumberForPhysical(int physicalLineNumber) {
        if (this.m_idx == 0) {
            return -1;
        }
        int lowerBd = 0;
        int upperBd = this.m_idx;
        int d;
        while ((d = upperBd - lowerBd) != 1) {
            int mid = (lowerBd + upperBd) / 2;
            int val = this.m_physicalLines[mid];
            if (val == physicalLineNumber) {
                return mid;
            }
            if (val > physicalLineNumber) {
                upperBd = mid;
                continue;
            }
            lowerBd = mid + 1;
        }
        return this.m_physicalLines[lowerBd] == physicalLineNumber ? lowerBd : -1;
    }
}

