/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.CheckResult;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.CheckResults;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfo;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfoEQClass;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.LocationWithLogicalLineNumber;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

final class EqClasses {
    private final Map<LocationWithLogicalLineNumber, Set<LocationWithLogicalLineNumber>> m_represents;
    private final Map<LocationWithLogicalLineNumber, int[]> m_bestDuplicatedBlockInfo;
    private static final int PHYSICAL_END = 0;
    private static final int TOLERANCE = 1;
    private static final int LOGICAL_END = 2;
    private final int m_minimalBlockLength;
    private final IWorkerContext m_workerContext;

    EqClasses(CheckResults checkResults, int minimalBlokLength, IWorkerContext workerContext) {
        assert (checkResults != null) : "Parameter 'checkResults' of method 'EqClasses' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'EqClasses' must not be null";
        this.m_minimalBlockLength = minimalBlokLength;
        this.m_workerContext = workerContext;
        THashMap m_representedBy = new THashMap();
        this.m_represents = new TreeMap<LocationWithLogicalLineNumber, Set<LocationWithLogicalLineNumber>>();
        this.m_bestDuplicatedBlockInfo = new THashMap();
        this.m_workerContext.beginBlockOfWork(checkResults.getMap().values().size());
        for (Map<String, List<CheckResult>> m2 : checkResults.getMap().values()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            for (List<CheckResult> crs : m2.values()) {
                for (CheckResult cr : crs) {
                    LocationWithLogicalLineNumber loc2Rep;
                    LocationWithLogicalLineNumber loc1Rep;
                    int[] rangeOfBlock2;
                    LocationWithLogicalLineNumber startLocationOfBlock1 = cr.getFrom1();
                    LocationWithLogicalLineNumber startLocationOfBlock2 = cr.getFrom2();
                    int endLineOfBlock1 = cr.getTo1().getPhysicalLineNumber();
                    int endLineOfBlock2 = cr.getTo2().getPhysicalLineNumber();
                    int tolerance = cr.getTolerance();
                    int[] rangeOfBlock1 = this.m_bestDuplicatedBlockInfo.get(startLocationOfBlock1);
                    if (rangeOfBlock1 == null || endLineOfBlock1 > rangeOfBlock1[0] || endLineOfBlock1 == rangeOfBlock1[0] && tolerance < rangeOfBlock1[1]) {
                        this.m_bestDuplicatedBlockInfo.put(startLocationOfBlock1, this.createBestDuplicateInfo(endLineOfBlock1, tolerance, cr.getTo1().getLogicalLineNumber()));
                    }
                    if ((rangeOfBlock2 = this.m_bestDuplicatedBlockInfo.get(startLocationOfBlock2)) == null || endLineOfBlock2 > rangeOfBlock2[0] || endLineOfBlock2 == rangeOfBlock2[0] && tolerance < rangeOfBlock2[1]) {
                        this.m_bestDuplicatedBlockInfo.put(startLocationOfBlock2, this.createBestDuplicateInfo(endLineOfBlock2, tolerance, cr.getTo2().getLogicalLineNumber()));
                    }
                    if (startLocationOfBlock1.compareTo(startLocationOfBlock2) > 0) {
                        LocationWithLogicalLineNumber tmp = startLocationOfBlock1;
                        startLocationOfBlock1 = startLocationOfBlock2;
                        startLocationOfBlock2 = tmp;
                    }
                    if ((loc1Rep = (LocationWithLogicalLineNumber)m_representedBy.get(startLocationOfBlock1)) == null) {
                        loc1Rep = startLocationOfBlock1;
                        m_representedBy.put(startLocationOfBlock1, startLocationOfBlock1);
                        TreeSet<LocationWithLogicalLineNumber> set = new TreeSet<LocationWithLogicalLineNumber>();
                        set.add(startLocationOfBlock1);
                        this.m_represents.put(startLocationOfBlock1, set);
                    }
                    if ((loc2Rep = (LocationWithLogicalLineNumber)m_representedBy.get(startLocationOfBlock2)) == null) {
                        loc2Rep = loc1Rep;
                        m_representedBy.put(startLocationOfBlock2, loc1Rep);
                        this.m_represents.get(loc1Rep).add(startLocationOfBlock2);
                        continue;
                    }
                    if (loc1Rep.equals(loc2Rep)) continue;
                    if (loc1Rep.compareTo(loc2Rep) > 0) {
                        LocationWithLogicalLineNumber tmp = loc1Rep;
                        loc1Rep = loc2Rep;
                        loc2Rep = tmp;
                    }
                    for (LocationWithLogicalLineNumber locToRemap : this.m_represents.get(loc2Rep)) {
                        m_representedBy.put(locToRemap, loc1Rep);
                    }
                    this.m_represents.get(loc1Rep).addAll((Collection<LocationWithLogicalLineNumber>)this.m_represents.get(loc2Rep));
                    this.m_represents.remove(loc2Rep);
                }
            }
            this.m_workerContext.workItemCompleted();
        }
    }

    private int[] createBestDuplicateInfo(int physicalLineNumberOfEnd, int tolerance, int logicalLineNumberEnd) {
        return new int[]{physicalLineNumberOfEnd, tolerance, logicalLineNumberEnd};
    }

    List<DuplicateBlockInfoEQClass> createEquivalenceClasses() {
        ArrayList<DuplicateBlockInfoEQClass> equivalenceClasses = new ArrayList<DuplicateBlockInfoEQClass>();
        this.m_workerContext.beginBlockOfWork(this.m_represents.values().size());
        for (Set<LocationWithLogicalLineNumber> represented : this.m_represents.values()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return Collections.unmodifiableList(equivalenceClasses);
            }
            DuplicateBlockInfoEQClass equivalentGroups = new DuplicateBlockInfoEQClass();
            this.remedyOverlapping(represented);
            for (LocationWithLogicalLineNumber nextLocation : represented) {
                int nextPhysicalLineNumber = nextLocation.getPhysicalLineNumber();
                int[] nextBestDuplicatedBlockInfo = this.m_bestDuplicatedBlockInfo.get(nextLocation);
                int nextMatchedLineCount = nextBestDuplicatedBlockInfo[0] - nextPhysicalLineNumber + 1;
                int nextLogicalMatchedLineCount = nextBestDuplicatedBlockInfo[2] - nextLocation.getLogicalLineNumber() + 1;
                if (nextLogicalMatchedLineCount < this.m_minimalBlockLength) continue;
                DuplicateBlockInfo nextDuplicateBlockInfo = new DuplicateBlockInfo(nextLocation.getPath(), nextMatchedLineCount, nextBestDuplicatedBlockInfo[1], nextPhysicalLineNumber, nextLogicalMatchedLineCount);
                equivalentGroups.add(nextDuplicateBlockInfo);
                int nextLastLine = equivalentGroups.getLastLine(nextPhysicalLineNumber, nextLocation.getPath());
                StrictPair<String, IntBasedHash> hashes = nextLocation.getFileContent().getHash(nextPhysicalLineNumber, nextLastLine);
                nextDuplicateBlockInfo.setHash(HashSupport.MD5.getHexString((String)hashes.getFirst()), (IntBasedHash)hashes.getSecond());
            }
            equivalenceClasses.add(equivalentGroups);
            this.m_workerContext.workItemCompleted();
        }
        equivalenceClasses.trimToSize();
        return equivalenceClasses;
    }

    private void remedyOverlapping(Set<LocationWithLogicalLineNumber> represented) {
        if (represented == null || represented.isEmpty()) {
            return;
        }
        LocationWithLogicalLineNumber[] representedArray = represented.toArray(new LocationWithLogicalLineNumber[represented.size()]);
        int i = representedArray.length - 1;
        while (i > 0) {
            LocationWithLogicalLineNumber locSecond = representedArray[i];
            int[] bestDuplicatedBlockInfoLocSecond = this.m_bestDuplicatedBlockInfo.get(locSecond);
            int startLocSecond = locSecond.getPhysicalLineNumber();
            int endLocSecond = bestDuplicatedBlockInfoLocSecond[0];
            String fileLocSecond = locSecond.getFileContent().getFile().getAbsolutePath();
            int j = i - 1;
            while (j >= 0) {
                LocationWithLogicalLineNumber locFirst = representedArray[j];
                int[] bestDuplicatedBlockInfoLocFirst = this.m_bestDuplicatedBlockInfo.get(locFirst);
                int startLocFirst = locFirst.getPhysicalLineNumber();
                int endLocFirst = bestDuplicatedBlockInfoLocFirst[0];
                String fileLocFirst = locFirst.getFileContent().getFile().getAbsolutePath();
                if (fileLocSecond.equals(fileLocFirst)) {
                    int toleranceMax = Math.max(bestDuplicatedBlockInfoLocFirst[1], bestDuplicatedBlockInfoLocSecond[1]);
                    if (startLocFirst < startLocSecond && endLocFirst == endLocSecond) {
                        this.m_bestDuplicatedBlockInfo.put(locFirst, this.createBestDuplicateInfo(startLocSecond, toleranceMax, bestDuplicatedBlockInfoLocSecond[2]));
                    } else if (startLocSecond > startLocFirst && endLocSecond < endLocFirst) {
                        this.m_bestDuplicatedBlockInfo.put(locFirst, this.createBestDuplicateInfo(startLocSecond, toleranceMax, bestDuplicatedBlockInfoLocSecond[2]));
                        this.m_bestDuplicatedBlockInfo.put(locSecond, this.createBestDuplicateInfo(endLocFirst, toleranceMax, bestDuplicatedBlockInfoLocFirst[2]));
                    } else if (startLocSecond > startLocFirst && endLocFirst < endLocSecond && startLocSecond < endLocFirst) {
                        this.m_bestDuplicatedBlockInfo.put(locFirst, this.createBestDuplicateInfo(startLocSecond, toleranceMax, bestDuplicatedBlockInfoLocFirst[2]));
                    }
                }
                --j;
            }
            --i;
        }
    }
}

