/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceFile;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLine;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.CheckResult;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.CheckResults;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfo;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfoEQClass;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.EqClasses;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.FileContent;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.Hash;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.LocationWithLogicalLineNumber;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.PhysicalLocation;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.SourceLine;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.text.Levenshtein;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DuplicateCodeChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateCodeChecker.class);
    private int m_maximumTolerancePerEdit = 3;
    private float m_maximumRelativeTolerance = 0.35f;
    private int m_minimalBlockLength = 25;
    private int m_maximumNumberOfCopiesConsidered = 100;
    private int m_minimumLineLength = 3;
    private final IWorkerContext m_workerContext;

    public DuplicateCodeChecker(int minimalLineLength, int maximalTolerance, int minimalBlockLength, int maximumNumberOfCopies, int maximumRelativeTolerancePercentage, IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'DuplicateCodeChecker' must not be null";
        this.m_workerContext = workerContext;
        this.m_maximumTolerancePerEdit = maximalTolerance;
        this.m_minimalBlockLength = minimalBlockLength;
        this.m_maximumRelativeTolerance = (float)maximumRelativeTolerancePercentage / 100.0f;
        this.m_maximumNumberOfCopiesConsidered = maximumNumberOfCopies;
        this.m_minimumLineLength = minimalLineLength;
    }

    private int compareGroupInfos(DuplicateBlockInfo o1, DuplicateBlockInfo o2) {
        int blockLengthDiff = o2.getMatchedLineCount() - o1.getMatchedLineCount();
        if (blockLengthDiff != 0) {
            return blockLengthDiff;
        }
        int toleranceDiff = o1.getTolerance() - o2.getTolerance();
        if (toleranceDiff != 0) {
            return toleranceDiff;
        }
        int lexicographicDiff = o1.getFile().getAbsolutePath().compareTo(o2.getFile().getAbsolutePath());
        if (lexicographicDiff != 0) {
            return lexicographicDiff;
        }
        return o1.getBlockBegin() - o2.getBlockBegin();
    }

    private void sortDuplicateBlockInfoEQClasses(List<DuplicateBlockInfoEQClass> data) {
        assert (data != null) : "Parameter 'data' of method 'sortDuplicateBlockInfoEQClasses' must not be null";
        for (DuplicateBlockInfoEQClass infos : data) {
            this.sortGroupInfos(infos);
        }
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        Collections.sort(data, new Comparator<DuplicateBlockInfoEQClass>(){

            @Override
            public int compare(DuplicateBlockInfoEQClass o1, DuplicateBlockInfoEQClass o2) {
                int o2s;
                int o1s = o1.getElements().size();
                if (o1s != (o2s = o2.getElements().size())) {
                    return o2s - o1s;
                }
                if (o1s == 0) {
                    return 0;
                }
                return DuplicateCodeChecker.this.compareGroupInfos(o1.getElements().get(0), o2.getElements().get(0));
            }
        });
    }

    private void sortGroupInfos(DuplicateBlockInfoEQClass copies) {
        Collections.sort(copies.getElements(), new Comparator<DuplicateBlockInfo>(){

            @Override
            public int compare(DuplicateBlockInfo o1, DuplicateBlockInfo o2) {
                return DuplicateCodeChecker.this.compareGroupInfos(o1, o2);
            }
        });
    }

    public List<DuplicateBlockInfoEQClass> compute(Iterator<RelevantSourceFile> relevantSourceFileIterator, int totalNumberOfSourceFiles) {
        List<DuplicateBlockInfoEQClass> duplicateBlockInfoEQClasses = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting search for duplicate code blocks");
        }
        this.m_workerContext.setNumberOfSteps(3, new int[]{70, 22, 8});
        CheckResults checkResults = this.processAllFiles(relevantSourceFileIterator, totalNumberOfSourceFiles);
        this.m_workerContext.endStep();
        if (checkResults != null && !this.m_workerContext.hasBeenCanceled()) {
            EqClasses equivalenceClasses = new EqClasses(checkResults, this.m_minimalBlockLength, this.m_workerContext);
            this.m_workerContext.endStep();
            if (this.m_workerContext.hasBeenCanceled()) {
                return duplicateBlockInfoEQClasses;
            }
            duplicateBlockInfoEQClasses = equivalenceClasses.createEquivalenceClasses();
            this.m_workerContext.endStep();
            if (this.m_workerContext.hasBeenCanceled()) {
                return duplicateBlockInfoEQClasses;
            }
            this.sortDuplicateBlockInfoEQClasses(duplicateBlockInfoEQClasses);
        } else {
            this.m_workerContext.stop();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished search for duplicate code blocks");
        }
        return duplicateBlockInfoEQClasses;
    }

    private CheckResults processAllFiles(Iterator<RelevantSourceFile> iterator, int totalNumberOfSourceFiles) {
        assert (iterator != null) : "Parameter 'iterator' of method 'processAllFiles' must not be null";
        THashMap samePositionContent = new THashMap(1000000);
        boolean IGNORE_CONTENT_FLAG = false;
        THashMap unifyingMapForHashes = new THashMap();
        this.m_workerContext.beginBlockOfWork(totalNumberOfSourceFiles);
        while (iterator.hasNext()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return null;
            }
            RelevantSourceFile nextRelevantSourceFile = iterator.next();
            FileContent fileContent = new FileContent(nextRelevantSourceFile.getFile());
            for (RelevantSourceLine nextRelevantSourceLine : nextRelevantSourceFile.getRelevantSourceLines()) {
                SourceLine sourceLine = new SourceLine(nextRelevantSourceLine.getContent(), new PhysicalLocation(fileContent, nextRelevantSourceLine.getLine()));
                if (nextRelevantSourceLine.getLineLength() < this.m_minimumLineLength) continue;
                Hash hash = new Hash(HashSupport.MD5.getHash(sourceLine.getContent()));
                if (unifyingMapForHashes.containsKey(hash)) {
                    hash = (Hash)unifyingMapForHashes.get(hash);
                } else {
                    unifyingMapForHashes.put(hash, hash);
                }
                PhysicalLocation loc = sourceLine.getLocation();
                Object occurrences = samePositionContent.get(hash);
                if (occurrences == null) {
                    samePositionContent.put(hash, loc);
                } else if (!occurrences.equals(0)) {
                    if (!(occurrences instanceof List)) {
                        assert (occurrences instanceof PhysicalLocation) : "A non-list must be a QDPhysicalLocation";
                        occurrenceList = new ArrayList<PhysicalLocation>(5);
                        occurrenceList.add((PhysicalLocation)occurrences);
                        occurrenceList.add(loc);
                        samePositionContent.put(hash, occurrenceList);
                    } else {
                        occurrenceList = (ArrayList<PhysicalLocation>)occurrences;
                        if (occurrenceList.size() == this.m_maximumNumberOfCopiesConsidered) {
                            samePositionContent.put(hash, 0);
                        } else {
                            occurrenceList.add(loc);
                        }
                    }
                }
                fileContent.addHashLine(hash.getArray(), sourceLine.getPhysicalLineNumber(), Levenshtein.createIntHash((String)sourceLine.getContent()));
            }
            this.m_workerContext.workItemCompleted();
            fileContent.trimToSize();
        }
        unifyingMapForHashes.clear();
        Iterator it = samePositionContent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (value instanceof List) continue;
            it.remove();
        }
        CheckResults checkResults = new CheckResults();
        for (Map.Entry entry : samePositionContent.entrySet()) {
            List occurrenceList = (List)entry.getValue();
            int i = 0;
            while (i < occurrenceList.size() - 1) {
                LocationWithLogicalLineNumber locI = ((PhysicalLocation)occurrenceList.get(i)).createLocationWithLogicalLineNumber();
                int j = i + 1;
                while (j < occurrenceList.size()) {
                    LocationWithLogicalLineNumber locJ = ((PhysicalLocation)occurrenceList.get(j)).createLocationWithLogicalLineNumber();
                    CheckResult checkResult = this.checkIfDuplicateBlockStarts(locI, locJ);
                    if (checkResult != null) {
                        checkResults.addCheckResult(checkResult);
                    }
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return null;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return checkResults;
    }

    private CheckResult checkIfDuplicateBlockStarts(LocationWithLogicalLineNumber locationWithLogicalLineNumber1, LocationWithLogicalLineNumber locationWithLogicalLineNumber2) {
        LocationWithLogicalLineNumber.IFileContent file1 = locationWithLogicalLineNumber1.getFileContent();
        LocationWithLogicalLineNumber.IFileContent file2 = locationWithLogicalLineNumber2.getFileContent();
        int logicalLineNumberInBlock1 = locationWithLogicalLineNumber1.getLogicalLineNumber();
        int logicalLineNumberInBlock2 = locationWithLogicalLineNumber2.getLogicalLineNumber();
        int toleranceUsed = 0;
        int matchingPositions = 0;
        int firstLine2 = logicalLineNumberInBlock2;
        int maxLine1 = file1 != file2 ? file1.numberOfLogicalPositions() - 1 : firstLine2 - 1;
        int maxLine2 = file2.numberOfLogicalPositions() - 1;
        while (true) {
            if (logicalLineNumberInBlock1 <= maxLine1 && logicalLineNumberInBlock2 <= maxLine2 && file1.getHashForLogicalLineNumber(logicalLineNumberInBlock1) == file2.getHashForLogicalLineNumber(logicalLineNumberInBlock2)) {
                ++matchingPositions;
                ++logicalLineNumberInBlock1;
                ++logicalLineNumberInBlock2;
                continue;
            }
            if (logicalLineNumberInBlock1 > maxLine1 || logicalLineNumberInBlock2 > maxLine2) break;
            int toleratedPositionsForCurrentEdit = Math.min(this.m_maximumTolerancePerEdit, (int)((float)matchingPositions * this.m_maximumRelativeTolerance) - toleranceUsed);
            int changedPositions = DuplicateCodeChecker.changedPositionsAccounting(file1, logicalLineNumberInBlock1, maxLine1, file2, logicalLineNumberInBlock2, maxLine2, toleratedPositionsForCurrentEdit);
            int deletedPositions = DuplicateCodeChecker.deletedPositionsAccounting(file1, logicalLineNumberInBlock1, maxLine1, file2, logicalLineNumberInBlock2, toleratedPositionsForCurrentEdit);
            int addedPositions = DuplicateCodeChecker.deletedPositionsAccounting(file2, logicalLineNumberInBlock2, maxLine2, file1, logicalLineNumberInBlock1, toleratedPositionsForCurrentEdit);
            if (changedPositions == Integer.MAX_VALUE && deletedPositions == Integer.MAX_VALUE && addedPositions == Integer.MAX_VALUE) break;
            if (changedPositions != Integer.MAX_VALUE && deletedPositions >= changedPositions && addedPositions >= changedPositions) {
                toleranceUsed += changedPositions;
                logicalLineNumberInBlock1 += changedPositions;
                logicalLineNumberInBlock2 += changedPositions;
                continue;
            }
            if (deletedPositions != Integer.MAX_VALUE && changedPositions >= deletedPositions && addedPositions >= deletedPositions) {
                toleranceUsed += deletedPositions;
                logicalLineNumberInBlock1 += deletedPositions;
                continue;
            }
            toleranceUsed = addedPositions;
            logicalLineNumberInBlock2 += addedPositions;
        }
        if (logicalLineNumberInBlock1 == 0) {
            LOGGER.error("Should never occur!", (Throwable)new Error());
        }
        int blockLength1 = logicalLineNumberInBlock1 - locationWithLogicalLineNumber1.getLogicalLineNumber();
        int blockLength2 = logicalLineNumberInBlock2 - locationWithLogicalLineNumber2.getLogicalLineNumber();
        if (blockLength1 >= this.m_minimalBlockLength && blockLength2 >= this.m_minimalBlockLength) {
            return new CheckResult(matchingPositions, toleranceUsed, locationWithLogicalLineNumber1, file1.createLocation(logicalLineNumberInBlock1 - 1), locationWithLogicalLineNumber2, file2.createLocation(logicalLineNumberInBlock2 - 1));
        }
        return null;
    }

    private static int changedPositionsAccounting(LocationWithLogicalLineNumber.IFileContent file1, int line1, int maxLine1, LocationWithLogicalLineNumber.IFileContent file2, int line2, int maxLine2, int tolerance) {
        int i = 1;
        while (i <= tolerance && line1 + i <= maxLine1 && line2 + i <= maxLine2 && file1.getHashForLogicalLineNumber(line1 + i) != file2.getHashForLogicalLineNumber(line2 + i)) {
            ++i;
        }
        return i > tolerance || line1 + i > maxLine1 || line2 + i > maxLine2 ? Integer.MAX_VALUE : i;
    }

    private static int deletedPositionsAccounting(LocationWithLogicalLineNumber.IFileContent file1, int line1, int maxLine1, LocationWithLogicalLineNumber.IFileContent file2, int line2, int tolerance) {
        int i = 1;
        while (i <= tolerance && line1 + i <= maxLine1 && file1.getHashForLogicalLineNumber(line1 + i) != file2.getHashForLogicalLineNumber(line2)) {
            ++i;
        }
        return i > tolerance || line1 + i > maxLine1 ? Integer.MAX_VALUE : i;
    }
}

