/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.ExtendableEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.FocusModeCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.OnlyVisibleNotTransitiveCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.OnlyVisibleTransitiveCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.ProgrammingElementCheckerCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.RepresentationNavigationCollector;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class ExtendableEndpointCollectorFactory {
    private final SoftwareSystem m_softwareSystem;
    private final Set<NamedElement> m_mainNodes;
    private final Set<NamedElement> m_additionalNodes;
    private final Set<CoreParserDependencyType> m_dependencyTypes;
    private final IDomainRoot.Domain m_domain;
    private final PresentationMode m_presentationMode;
    private final boolean m_collectProgrammingElements;
    private final boolean m_dontCollectTypesRecursively;
    private final ExtendableEndpointCollectorType m_extendableEndpointCollectorType;
    private Map<NamedElement, NamedElement> m_namedElementToProxy;
    private Set<OnDemandCycleGroup> m_cycleNodes;
    private FocusMode m_focusMode;
    private Set<ProgrammingElement> m_programmingElementsForMainNodes;
    private Set<ProgrammingElement> m_programmingElementsForAdditionalNodes;
    private boolean m_allowTransitiveDependencies;
    private Set<NamedElement> m_newElementsForView;
    private EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> m_properties;

    private ExtendableEndpointCollectorFactory(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively, ExtendableEndpointCollectorType extendableEndpointCollectorType) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (mainNodes != null) : "Parameter 'mainNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (additionalNodes != null) : "Parameter 'additionalNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (dependencyTypes != null) : "Parameter 'dependencyTypes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (extendableEndpointCollectorType != null) : "Parameter 'extendableEndpointCollectorType' of method 'ExtendableEndpointCollectorFactory' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_mainNodes = this.mapToRepresentatives(mainNodes);
        this.m_additionalNodes = this.mapToRepresentatives(additionalNodes);
        this.m_dependencyTypes = dependencyTypes;
        this.m_domain = domain;
        this.m_presentationMode = presentationMode;
        this.m_collectProgrammingElements = collectProgrammingElements;
        this.m_dontCollectTypesRecursively = dontCollectTypesRecursively;
        this.m_extendableEndpointCollectorType = extendableEndpointCollectorType;
    }

    public ExtendableEndpointCollectorFactory(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively) {
        this(softwareSystem, mainNodes, additionalNodes, dependencyTypes, domain, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, ExtendableEndpointCollectorType.EXTENDABLE_ENDPOINT_COLLECTOR);
    }

    public ExtendableEndpointCollectorFactory(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<OnDemandCycleGroup> cycleNodes, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, FocusMode mode, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively) {
        this(softwareSystem, mainNodes, additionalNodes, dependencyTypes, domain, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, ExtendableEndpointCollectorType.FOCUS_MODE_COLLECTOR);
        assert (mode != null) : "Parameter 'mode' of method 'ExtendableEndpointCollectorFactory' must not be null";
        this.m_cycleNodes = cycleNodes;
        this.m_focusMode = mode;
    }

    public ExtendableEndpointCollectorFactory(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<OnDemandCycleGroup> cycleNodes, Set<ProgrammingElement> programmingElementsForMainNodes, Set<ProgrammingElement> programmingElementsForAdditionalNodes, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, FocusMode mode, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively) {
        this(softwareSystem, mainNodes, additionalNodes, dependencyTypes, domain, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, ExtendableEndpointCollectorType.ONLY_VISIBLE_NOT_TRANSITIVE_COLLECTOR);
        assert (programmingElementsForMainNodes != null) : "Parameter 'programmingElementsForMainNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (programmingElementsForAdditionalNodes != null) : "Parameter 'programmingElementsForAdditionalNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'ExtendableEndpointCollectorFactory' must not be null";
        this.m_cycleNodes = cycleNodes;
        this.m_programmingElementsForMainNodes = programmingElementsForMainNodes;
        this.m_programmingElementsForAdditionalNodes = programmingElementsForAdditionalNodes;
        this.m_focusMode = mode;
    }

    public ExtendableEndpointCollectorFactory(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<OnDemandCycleGroup> cycleNodes, Set<ProgrammingElement> programmingElementsForMainNodes, Set<ProgrammingElement> programmingElementsForAdditionalNodes, Map<NamedElement, NamedElement> namedElementToProxy, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, FocusMode mode, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively) {
        this(softwareSystem, mainNodes, additionalNodes, dependencyTypes, domain, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, ExtendableEndpointCollectorType.ONLY_VISIBLE_TRANSITIVE_COLLECTOR);
        assert (programmingElementsForMainNodes != null) : "Parameter 'programmingElementsForMainNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (programmingElementsForAdditionalNodes != null) : "Parameter 'programmingElementsForAdditionalNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'ExtendableEndpointCollectorFactory' must not be null";
        this.m_cycleNodes = cycleNodes;
        this.m_programmingElementsForMainNodes = programmingElementsForMainNodes;
        this.m_programmingElementsForAdditionalNodes = programmingElementsForAdditionalNodes;
        this.m_focusMode = mode;
    }

    public ExtendableEndpointCollectorFactory(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<ProgrammingElement> programmingElementsForMainNodes, Set<ProgrammingElement> programmingElementsForAdditionalNodes, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, boolean allowTransitiveDependencies, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively) {
        this(softwareSystem, mainNodes, additionalNodes, dependencyTypes, domain, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, ExtendableEndpointCollectorType.PROGRAMMING_ELEMENT_CHECKER_COLLECTOR);
        assert (programmingElementsForMainNodes != null) : "Parameter 'programmingElementsForMainNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (programmingElementsForAdditionalNodes != null) : "Parameter 'programmingElementsForAdditionalNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        this.m_programmingElementsForMainNodes = programmingElementsForMainNodes;
        this.m_programmingElementsForAdditionalNodes = programmingElementsForAdditionalNodes;
        this.m_allowTransitiveDependencies = allowTransitiveDependencies;
    }

    public ExtendableEndpointCollectorFactory(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<NamedElement> newElementsForView, Set<ProgrammingElement> programmingElementsForMainNodes, Set<ProgrammingElement> programmingElementsForAdditionalNodes, Set<CoreParserDependencyType> dependencyTypes, FocusMode focusMode, IDomainRoot.Domain domain, PresentationMode presentationMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, boolean collectProgrammingElements, boolean dontCollectTypesRecursively) {
        this(softwareSystem, mainNodes, additionalNodes, dependencyTypes, domain, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, ExtendableEndpointCollectorType.REPRESENTATION_NAVIGATION_COLLECTOR);
        assert (newElementsForView != null) : "Parameter 'newElementsForView' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (programmingElementsForMainNodes != null) : "Parameter 'programmingElementsForMainNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (programmingElementsForAdditionalNodes != null) : "Parameter 'programmingElementsForAdditionalNodes' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'ExtendableEndpointCollectorFactory' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'ExtendableEndpointCollectorFactory' must not be null";
        this.m_newElementsForView = this.mapToRepresentatives(newElementsForView);
        this.m_programmingElementsForMainNodes = programmingElementsForMainNodes;
        this.m_programmingElementsForAdditionalNodes = programmingElementsForAdditionalNodes;
        this.m_focusMode = focusMode;
        this.m_properties = properties;
    }

    public <T extends ExtendableEndpointCollector> T createExtendableEndpointCollector(EndpointType endpointType) {
        ExtendableEndpointCollector collector;
        assert (this.m_namedElementToProxy != null) : "'m_namedElementToProxy' of method 'createExtendableEndpointCollector' must not be null";
        assert (endpointType != null) : "Parameter 'endpointType' of method 'createExtendableEndpointCollector' must not be null";
        switch (this.m_extendableEndpointCollectorType) {
            case EXTENDABLE_ENDPOINT_COLLECTOR: {
                collector = new ExtendableEndpointCollector(this.m_softwareSystem, this.getMainNodes(), this.getAdditionalNodes(), this.m_namedElementToProxy, this.m_dependencyTypes, this.m_domain, this.m_presentationMode, this.m_collectProgrammingElements, this.m_dontCollectTypesRecursively, endpointType);
                break;
            }
            case FOCUS_MODE_COLLECTOR: {
                collector = new FocusModeCollector(this.m_softwareSystem, this.getMainNodes(), this.getAdditionalNodes(), this.m_cycleNodes, this.m_namedElementToProxy, this.m_dependencyTypes, this.m_domain, this.m_focusMode, this.m_presentationMode, this.m_collectProgrammingElements, this.m_dontCollectTypesRecursively, endpointType);
                break;
            }
            case ONLY_VISIBLE_NOT_TRANSITIVE_COLLECTOR: {
                collector = new OnlyVisibleNotTransitiveCollector(this.m_softwareSystem, this.getMainNodes(), this.getAdditionalNodes(), this.m_cycleNodes, this.m_programmingElementsForMainNodes, this.m_programmingElementsForAdditionalNodes, this.m_namedElementToProxy, this.m_dependencyTypes, this.m_domain, this.m_focusMode, this.m_presentationMode, this.m_collectProgrammingElements, this.m_dontCollectTypesRecursively, endpointType);
                break;
            }
            case ONLY_VISIBLE_TRANSITIVE_COLLECTOR: {
                collector = new OnlyVisibleTransitiveCollector(this.m_softwareSystem, this.getMainNodes(), this.getAdditionalNodes(), this.m_cycleNodes, this.m_programmingElementsForMainNodes, this.m_programmingElementsForAdditionalNodes, this.m_namedElementToProxy, this.m_dependencyTypes, this.m_domain, this.m_focusMode, this.m_presentationMode, this.m_collectProgrammingElements, this.m_dontCollectTypesRecursively, endpointType);
                break;
            }
            case PROGRAMMING_ELEMENT_CHECKER_COLLECTOR: {
                collector = new ProgrammingElementCheckerCollector(this.m_softwareSystem, this.getMainNodes(), this.getAdditionalNodes(), this.m_programmingElementsForMainNodes, this.m_programmingElementsForAdditionalNodes, this.m_namedElementToProxy, this.m_dependencyTypes, this.m_domain, this.m_allowTransitiveDependencies, this.m_presentationMode, this.m_collectProgrammingElements, this.m_dontCollectTypesRecursively, endpointType);
                break;
            }
            case REPRESENTATION_NAVIGATION_COLLECTOR: {
                collector = new RepresentationNavigationCollector(this.m_softwareSystem, this.getMainNodes(), this.getAdditionalNodes(), this.m_newElementsForView, this.m_programmingElementsForMainNodes, this.m_programmingElementsForAdditionalNodes, this.m_namedElementToProxy, this.m_dependencyTypes, this.m_focusMode, this.m_domain, this.m_presentationMode, this.m_properties, this.m_collectProgrammingElements, this.m_dontCollectTypesRecursively, endpointType);
                break;
            }
            default: {
                collector = null;
                assert (false) : "Unexpected value for 'extendableEndpointCollectorType': " + String.valueOf((Object)this.m_extendableEndpointCollectorType);
                break;
            }
        }
        assert (collector != null);
        return (T)collector;
    }

    private <T extends NamedElement> Set<T> mapToRepresentatives(Set<T> elementsToMap) {
        assert (elementsToMap != null) : "Parameter 'elementsToMap' of method 'mapToRepresentatives' must not be null";
        LinkedHashSet mapped = new LinkedHashSet(elementsToMap.size());
        elementsToMap.forEach(n -> {
            boolean bl = mapped.add(n.getRepresentative());
        });
        return mapped;
    }

    public Set<NamedElement> getMainNodes() {
        return this.m_mainNodes;
    }

    public Set<NamedElement> getAdditionalNodes() {
        return this.m_additionalNodes;
    }

    public void setNamedElementToProxy(Map<NamedElement, NamedElement> namedElementToProxy) {
        assert (namedElementToProxy != null) : "Parameter 'namedElementToProxy' of method 'setNamedElementToProxy' must not be null";
        this.m_namedElementToProxy = namedElementToProxy.entrySet().stream().collect(Collectors.toMap(entry -> ((NamedElement)entry.getKey()).getRepresentative(), entry -> (NamedElement)entry.getValue()));
    }

    static enum ExtendableEndpointCollectorType {
        EXTENDABLE_ENDPOINT_COLLECTOR,
        REPRESENTATION_NAVIGATION_COLLECTOR,
        PROGRAMMING_ELEMENT_CHECKER_COLLECTOR,
        FOCUS_MODE_COLLECTOR,
        ONLY_VISIBLE_NOT_TRANSITIVE_COLLECTOR,
        ONLY_VISIBLE_TRANSITIVE_COLLECTOR;

    }
}

