/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.representation.ProgrammingElementCollector;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.IRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ExtendableEndpointCollector
extends DependencyEndpointCollector {
    private final Map<NamedElement, Set<ProgrammingElement>> m_mainNodeToProgrammingElements;
    private final Map<NamedElement, Set<ProgrammingElement>> m_additionalNodeToProgrammingElements;
    private final Set<CoreParserDependencyType> m_dependencyTypes;
    private final Map<NamedElement, NamedElement> m_namedElementToProxy;
    private final Map<IAssignableToArtifact, AssignedElement> m_assignableToProxyCollector;
    private final SoftwareSystem m_softwareSystem;
    private final IDomainRoot.Domain m_domain;
    private final PresentationMode m_presentationMode;
    private final EndpointType m_endpointType;

    public ExtendableEndpointCollector(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Map<NamedElement, NamedElement> namedElementToProxy, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively, EndpointType endpointType) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ExtendableProgrammingElementCollector' must not be null";
        assert (mainNodes != null) : "Parameter 'mainNodes' of method 'ExtendableEndpointCollector' must not be null";
        assert (additionalNodes != null) : "Parameter 'additionalNodes' of method 'ExtendableProgrammingElementCollector' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'ExtendableProgrammingElementCollector' must not be null";
        assert (dependencyTypes != null) : "Parameter 'dependencyTypes' of method 'ExtendableEndpointCollector' must not be null";
        assert (namedElementToProxy != null) : "Parameter 'programmingElementToLogicalProgrammingElement' of method 'ExtendableEndpointCollector' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'ExtendableEndpointCollector' must not be null";
        assert (endpointType != null) : "Parameter 'endpointType' of method 'ExtendableEndpointCollector' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_domain = domain;
        this.m_presentationMode = presentationMode;
        this.m_dependencyTypes = dependencyTypes;
        this.m_namedElementToProxy = namedElementToProxy;
        this.m_mainNodeToProgrammingElements = new THashMap(mainNodes.size());
        this.m_additionalNodeToProgrammingElements = new THashMap(additionalNodes.size());
        this.m_endpointType = endpointType;
        if (collectProgrammingElements) {
            ProgrammingElementCollector nextVisitor;
            THashSet nextProgrammingElements;
            this.m_assignableToProxyCollector = domain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL || domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL ? new THashMap() : null;
            IRepresentationProvider extension = softwareSystem.getExtension(IRepresentationProvider.class);
            for (NamedElement nextNamedElement : mainNodes) {
                nextProgrammingElements = new THashSet();
                nextVisitor = new ProgrammingElementCollector(extension, domain, presentationMode, (Set<ProgrammingElement>)nextProgrammingElements, this.m_assignableToProxyCollector, nextNamedElement, mainNodes, additionalNodes, dontCollectTypesRecursively);
                nextNamedElement.accept(nextVisitor);
                this.m_mainNodeToProgrammingElements.put(nextNamedElement, (Set<ProgrammingElement>)nextProgrammingElements);
            }
            for (NamedElement nextNamedElement : additionalNodes) {
                nextProgrammingElements = new THashSet();
                nextVisitor = new ProgrammingElementCollector(extension, domain, presentationMode, (Set<ProgrammingElement>)nextProgrammingElements, this.m_assignableToProxyCollector, nextNamedElement, mainNodes, additionalNodes, false);
                nextNamedElement.accept(nextVisitor);
                this.m_additionalNodeToProgrammingElements.put(nextNamedElement, (Set<ProgrammingElement>)nextProgrammingElements);
            }
        } else {
            for (NamedElement nextNode : mainNodes) {
                this.m_mainNodeToProgrammingElements.put(nextNode, null);
            }
            for (NamedElement nextNode : additionalNodes) {
                this.m_additionalNodeToProgrammingElements.put(nextNode, null);
            }
            this.m_assignableToProxyCollector = null;
        }
    }

    public final Map<NamedElement, Set<ProgrammingElement>> getProgrammingElementsOfMainNodes() {
        return this.m_mainNodeToProgrammingElements;
    }

    public final Map<NamedElement, Set<ProgrammingElement>> getProgrammingElementsOfAdditionalNodes() {
        return this.m_additionalNodeToProgrammingElements;
    }

    public final Set<ProgrammingElement> getProgrammingElements(NamedElement forNamedElement) {
        assert (forNamedElement != null) : "Parameter 'forNamedElement' of method 'getProgrammingElements' must not be null";
        Set<ProgrammingElement> programmingElements = this.m_mainNodeToProgrammingElements.get(forNamedElement);
        if (programmingElements == null) {
            programmingElements = this.m_additionalNodeToProgrammingElements.get(forNamedElement);
        }
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'getProgrammingElements' must not be null";
        return Collections.unmodifiableSet(programmingElements);
    }

    @Override
    public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
        ParserDependency parserDependency;
        assert (from != null) : "Parameter 'from' of method 'addDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addDependency' must not be null";
        return !(dependency instanceof ParserDependency) || this.isAllowedDependencyType(parserDependency = (ParserDependency)dependency);
    }

    public final Set<IParserDependencyType> getAllowedDependencyTypes() {
        return this.m_dependencyTypes != null ? Collections.unmodifiableSet(this.m_dependencyTypes) : null;
    }

    protected final boolean isAllowedDependencyType(Dependency dependency) {
        if (this.m_dependencyTypes != null && dependency instanceof ParserDependency) {
            return this.m_dependencyTypes.contains(((ParserDependency)dependency).getDependencyType().getGenericDependencyType());
        }
        return true;
    }

    protected final Set<NamedElement> getMainNodes() {
        return Collections.unmodifiableSet(this.m_mainNodeToProgrammingElements.keySet());
    }

    protected final Set<NamedElement> getAdditionalNodes() {
        return Collections.unmodifiableSet(this.m_additionalNodeToProgrammingElements.keySet());
    }

    public final void updateProgrammingElementsForMainNode(NamedElement element, Set<ProgrammingElement> elementsToRetain) {
        assert (element != null) : "Parameter 'element' of method 'updateProgrammingElementsForMainNode' must not be null";
        assert (elementsToRetain != null) : "Parameter 'elementsToRetain' of method 'updateProgrammingElementsForMainNode' must not be null";
        Set<ProgrammingElement> programmingElements = this.m_mainNodeToProgrammingElements.get(element);
        if (programmingElements != null) {
            programmingElements.retainAll(elementsToRetain);
        }
    }

    public final void updateProgrammingElementsForAdditionalNode(NamedElement element, Set<ProgrammingElement> elementsToRetain) {
        assert (element != null) : "Parameter 'element' of method 'updateProgrammingElementsForAdditionalNode' must not be null";
        assert (elementsToRetain != null) : "Parameter 'elementsToRetain' of method 'updateProgrammingElementsForAdditionalNode' must not be null";
        Set<ProgrammingElement> programmingElements = this.m_additionalNodeToProgrammingElements.get(element);
        if (programmingElements != null) {
            programmingElements.retainAll(elementsToRetain);
        }
    }

    protected final boolean isHierarchical() {
        return this.m_presentationMode == PresentationMode.HIERARCHICAL;
    }

    @Override
    public final NamedElement getFirstCandidateForNodeAdapterLookUp(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getFirstCandidateForNodeAdapterLookUp' must not be null";
        if (this.m_domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE || this.m_domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE) {
            if (element instanceof ProgrammingElement) {
                if (element.isExcluded() || !((ProgrammingElement)element).includeInLogicalModel()) {
                    return null;
                }
                NamedElement proxy = this.m_namedElementToProxy.get(element);
                if (proxy != null) {
                    assert (proxy instanceof LogicalProgrammingElement) : "Unexpected class in method 'getFirstCandidateForNodeAdapterLookUp': " + String.valueOf(proxy);
                    element = proxy;
                }
            }
            return element;
        }
        if (this.m_domain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL) {
            assert (element instanceof ProgrammingElement);
            IAssignableToArtifact component = element.getParent(IAssignableToArtifact.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (component != null) {
                if (component.isExcluded()) {
                    return null;
                }
                assert (this.m_assignableToProxyCollector != null) : " 'm_componentToProxyCollector' of method 'getFirstCandidateForNodeAdapterLookUp' must not be null";
                return this.m_assignableToProxyCollector.get(component);
            }
        } else if (this.m_domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
            assert (element instanceof ProgrammingElement);
            ProgrammingElement topMost = element.getParent(ProgrammingElement.class, ParentMode.TOPMOST_PARENT_OR_SELF);
            NamedElement proxy = this.m_namedElementToProxy.get(topMost);
            if (proxy != null) {
                assert (proxy instanceof IAssignableToArtifact);
                IAssignableToArtifact assignable = (IAssignableToArtifact)((Object)proxy);
                return this.m_assignableToProxyCollector.get(assignable);
            }
        }
        return element;
    }

    @Override
    public final NamedElement getNextCandidateForNodeAdapterLookUp(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getNextCandidateForNodeAdapterLookUp' must not be null";
        if (this.m_endpointType == EndpointType.PARSER_DEPENDENCY) {
            if ((this.m_domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE || this.m_domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE) && element instanceof ProgrammingElement) {
                ProgrammingElement programmingElement = element.getParent(ProgrammingElement.class, ParentMode.FIRST_PARENT);
                if (programmingElement != null) {
                    NamedElement proxy = this.m_namedElementToProxy.get(programmingElement);
                    if (proxy != null) {
                        assert (proxy instanceof LogicalProgrammingElement) : "Unexpected class in method 'getNextCandidateForNodeAdapterLookUp': " + String.valueOf(proxy);
                        return proxy;
                    }
                } else {
                    if (element.isExcluded() || !((ProgrammingElement)element).includeInLogicalModel()) {
                        return null;
                    }
                    return RepresentationUtility.getLogicalNamespaceForProgrammingElement(this.m_softwareSystem, (ProgrammingElement)element, this.m_domain);
                }
            }
            return this.getParentFromPresentationMode(element);
        }
        if (this.m_endpointType == EndpointType.WORKSPACE_DEPENDENCY) {
            return null;
        }
        if (this.m_endpointType == EndpointType.INCLUDE_DEPENDENCY) {
            return null;
        }
        return super.getNextCandidateForNodeAdapterLookUp(element);
    }

    protected static boolean isParserDependencyInRepresentation(Set<NamedElement> mainNodes, Set<ProgrammingElement> programmingElementsForMainNodes, Set<ProgrammingElement> programmingElementsForAdditionalNodes, NamedElement from, NamedElement to, ParserDependency dependency) {
        assert (mainNodes != null) : "Parameter 'mainNodes' of method 'isParserDependencyInRepresentation' must not be null";
        assert (programmingElementsForMainNodes != null) : "Parameter 'programmingElementsForMainNodes' of method 'isParserDependencyInRepresentation' must not be null";
        assert (programmingElementsForAdditionalNodes != null) : "Parameter 'programmingElementsForAdditionalNodes' of method 'isParserDependencyInRepresentation' must not be null";
        assert (from != null) : "Parameter 'from' of method 'isProgrammingElementInRepresentation' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isProgrammingElementInRepresentation' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'isProgrammingElementInRepresentation' must not be null";
        if (mainNodes.contains(from) ? !programmingElementsForMainNodes.contains(dependency.getFrom()) : !programmingElementsForAdditionalNodes.contains(dependency.getFrom())) {
            return false;
        }
        return !(mainNodes.contains(to) ? !programmingElementsForMainNodes.contains(dependency.getTo()) : !programmingElementsForAdditionalNodes.contains(dependency.getTo()));
    }

    public final NamedElement getParentFromPresentationMode(NamedElement element) {
        NamedElement parent;
        assert (element != null) : "Parameter 'element' of method 'getParentFromPresentationMode' must not be null";
        if (!(element instanceof IRecursiveElement)) {
            return element.getParent();
        }
        switch (this.m_presentationMode) {
            case HIERARCHICAL: 
            case MIXED: {
                parent = element.getParent();
                break;
            }
            case FLAT: {
                assert (element instanceof IRecursiveElement) : "Unexpected element for flat mode calculation: " + String.valueOf(element);
                parent = element.getParent();
                while (parent != null && parent instanceof IRecursiveElement) {
                    parent = parent.getParent();
                }
                break;
            }
            default: {
                assert (false) : "Unexpected presentation mode " + String.valueOf((Object)this.m_presentationMode);
                parent = null;
            }
        }
        assert (parent != null) : "'parent' of method 'getParentFromPrentationMode' must not be null";
        return parent;
    }
}

