/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.remoting;

import com.hello2morrow.sonargraph.core.model.remoting.RemoteSelectionData;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.IConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteSelectionClient {
    public static final String FQ_NAME_SEPARATOR = "!!;";
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteSelectionClient.class);
    private final int m_port;

    public RemoteSelectionClient(int port) {
        this.m_port = port;
    }

    public OperationResult select(Version version, String systemPath, List<String> descriptors) {
        assert (version != null) : "Parameter 'version' of method 'select' must not be null";
        assert (systemPath != null && systemPath.length() > 0) : "Parameter 'systemPath' of method 'select' must not be empty";
        assert (descriptors != null && !descriptors.isEmpty()) : "Parameter 'descriptors' of method 'select' must not be empty";
        OperationResult result = new OperationResult("Selecting " + String.valueOf(descriptors));
        String baseUrlPart = this.createBaseUrl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Parameter.VERSION.getParameterName(), version.toString());
        headers.put(Parameter.SYSTEM_PATH.getParameterName(), systemPath);
        StringBuilder url = new StringBuilder(baseUrlPart);
        this.addParametersForMultiSelect(headers, descriptors);
        LOGGER.debug("Sending remote selection request for elements {}", descriptors);
        HttpConnectionConsumer connectionConsumer = new HttpConnectionConsumer();
        String response = HttpConnectionCheck.getContent((String)url.toString(), headers, null, (IConnectionConsumer)connectionConsumer);
        LOGGER.debug("Response: {}", (Object)response);
        switch (connectionConsumer.getResult()) {
            case FAILURE: {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, "Sending selection event failed: \n" + connectionConsumer.getLastMessage(), new Object[0]);
                break;
            }
            case TIMEOUT: {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, "Sending selection event timed out: \n" + connectionConsumer.getLastMessage(), new Object[0]);
                break;
            }
            case CANCELED: {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, "Sending selection event canceled: \n" + connectionConsumer.getLastMessage(), new Object[0]);
                break;
            }
            case SUCCESS: {
                if (response != null && response.startsWith("Error: ")) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, response, new Object[0]);
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, connectionConsumer.getLastMessage(), new Object[0]);
                    break;
                }
                if (response == null || !response.contains("Warning - ")) break;
                this.addWarningToResult(result, response);
            }
        }
        return result;
    }

    private void addWarningToResult(OperationResult result, String response) {
        assert (result != null) : "Parameter 'result' of method 'addWarningToResult' must not be null";
        assert (response != null && response.length() > 0) : "Parameter 'response' of method 'addWarningToResult' must not be empty";
        RemoteMessageCause[] remoteMessageCauseArray = RemoteMessageCause.values();
        int n = remoteMessageCauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteMessageCause next = remoteMessageCauseArray[n2];
            int pos = response.indexOf(next.getPresentationName());
            int beginIndex = pos + next.getPresentationName().length() + 2;
            if (pos > 0 && response.length() > beginIndex) {
                result.addWarning((OperationResult.IMessageCause)next, response.substring(beginIndex), new Object[0]);
                return;
            }
            ++n2;
        }
    }

    public OperationResult selectSingle(Version version, String systemPath, RemoteSelectionData data) {
        assert (version != null) : "Parameter 'version' of method 'selectSingle' must not be null";
        assert (systemPath != null && systemPath.length() > 0) : "Parameter 'systemPath' of method 'selectSingle' must not be empty";
        assert (data != null) : "Parameter 'data' of method 'selectSingle' must not be null";
        OperationResult result = new OperationResult("Sending single selection request");
        String baseUrl = this.createBaseUrl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Parameter.VERSION.getParameterName(), version.toString());
        headers.put(Parameter.SYSTEM_PATH.getParameterName(), systemPath);
        this.addParametersForSingleSelect(headers, data.getDescriptor(), data.getSourceFilePath(), data.getLine());
        LOGGER.debug("Sending remote single selection request for element {}", (Object)data.getDescriptor());
        HttpConnectionConsumer connectionConsumer = new HttpConnectionConsumer(){

            public void working(String message) {
                super.working(message);
                LOGGER.debug(message);
            }
        };
        String response = HttpConnectionCheck.getContent((String)baseUrl, headers, null, (IConnectionConsumer)connectionConsumer);
        LOGGER.debug("Response: {}", (Object)response);
        switch (connectionConsumer.getResult()) {
            case FAILURE: {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, "Sending selection event failed: \n" + connectionConsumer.getLastMessage(), new Object[0]);
                break;
            }
            case TIMEOUT: {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, "Sending selection event timed out: \n" + connectionConsumer.getLastMessage(), new Object[0]);
                break;
            }
            case CANCELED: {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, "Sending selection event canceled: \n" + connectionConsumer.getLastMessage(), new Object[0]);
                break;
            }
            case SUCCESS: {
                if (response == null || !response.startsWith("Error: ")) break;
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, response, new Object[0]);
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CONNECT, connectionConsumer.getLastMessage(), new Object[0]);
            }
        }
        return result;
    }

    private String createBaseUrl() {
        StringBuilder url = new StringBuilder("http://localhost:");
        url.append(this.m_port);
        url.append("/selection");
        String urlString = url.toString();
        return urlString;
    }

    private void addParametersForMultiSelect(Map<String, String> headers, List<String> descriptors) {
        assert (headers != null) : "Parameter 'headers' of method 'addParametersForMultiSelect' must not be null";
        assert (descriptors != null && !descriptors.isEmpty()) : "Parameter 'descriptors' of method 'createUrl' must not be empty";
        String fqNameSequence = descriptors.stream().collect(Collectors.joining(FQ_NAME_SEPARATOR));
        headers.put(Parameter.MULTIPLE_DESCRIPTORS.getParameterName(), URLEncoder.encode(fqNameSequence, StandardCharsets.UTF_8));
    }

    private void addParametersForSingleSelect(Map<String, String> headers, String descriptor, String sourcePath, int line) {
        assert (headers != null) : "Parameter 'headers' of method 'addParametersForSingleSelect' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'createParametersForSingleSelect' must not be empty";
        headers.put(Parameter.SINGLE_DESCRIPTOR.getParameterName(), descriptor);
        if (sourcePath != null) {
            headers.put(Parameter.SOURCE.getParameterName(), sourcePath);
            if (line >= 0) {
                headers.put(Parameter.LINE.getParameterName(), Integer.toString(line));
            }
        }
    }

    public static final class Parameter
    extends Enum<Parameter>
    implements IStandardEnumeration {
        public static final /* enum */ Parameter VERSION = new Parameter("v");
        public static final /* enum */ Parameter SYSTEM_PATH = new Parameter("s-path");
        public static final /* enum */ Parameter MULTIPLE_DESCRIPTORS = new Parameter("desc");
        public static final /* enum */ Parameter SINGLE_DESCRIPTOR = new Parameter("d");
        public static final /* enum */ Parameter SOURCE = new Parameter("s");
        public static final /* enum */ Parameter LINE = new Parameter("l");
        private final String m_parameterName;
        private static final /* synthetic */ Parameter[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Parameter[]{VERSION, SYSTEM_PATH, MULTIPLE_DESCRIPTORS, SINGLE_DESCRIPTOR, SOURCE, LINE};
        }

        private Parameter(String parameterName) {
            assert (parameterName != null && parameterName.length() > 0) : "Parameter 'parameterName' of method 'Parameter' must not be empty";
            this.m_parameterName = parameterName;
        }

        public String getParameterName() {
            return this.m_parameterName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        public static Parameter[] values() {
            Parameter[] parameterArray = ENUM$VALUES;
            int n = parameterArray.length;
            Parameter[] parameterArray2 = new Parameter[n];
            System.arraycopy(ENUM$VALUES, 0, parameterArray2, 0, n);
            return parameterArray2;
        }

        public static Parameter valueOf(String string) {
            return Enum.valueOf(Parameter.class, string);
        }
    }

    public static enum RemoteMessageCause implements OperationResult.IMessageCause
    {
        STARTED_SERVER,
        STOPPED_SERVER,
        FAILED_TO_START_SERVER,
        FAILED_TO_STOP_SERVER,
        VERSION_MISMATCH,
        SYSTEM_MISMATCH,
        SYSTEM_MISSING,
        UNSUPPORTED_PRODUCT,
        FAILED_TO_LOAD_CONFIGURATION;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

