/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.graphview;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.DirectoryDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalNamespaceDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalProgrammingElementDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.graphview.GraphViewArchitectureInfoProcessor;
import com.hello2morrow.sonargraph.core.controller.system.graphview.GraphViewElementResolver;
import com.hello2morrow.sonargraph.core.controller.system.graphview.GraphViewResetStateVisitor;
import com.hello2morrow.sonargraph.core.controller.system.graphview.GraphViewStateCollector;
import com.hello2morrow.sonargraph.core.controller.system.graphview.GraphViewUpdateDependenciesVisitor;
import com.hello2morrow.sonargraph.core.controller.system.graphview.ISystemDiffAdditionalInfoProvider;
import com.hello2morrow.sonargraph.core.controller.system.graphview.MarkAddedCyclicElementsVisitor;
import com.hello2morrow.sonargraph.core.controller.system.graphview.ResetAddedCyclicElementsVisitor;
import com.hello2morrow.sonargraph.core.controller.system.graphview.UnderlyingNamedElementCollector;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.IAnalyzer;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewRepresentationInfo;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewCycleGroupNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewCyclicNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNodeWithUnderlyingElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNonCyclicNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewRepresentation;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewState;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewStructureMode;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphViewRepresentationHandler.class);
    private static final Predicate<ProgrammingElement> PE = pe -> !pe.isExcluded() && !pe.getRefactoringState().hasBeenDeleted();
    private static final Predicate<ParserDependency> PD = pd -> pd.includeInCycleAnalysis() && !pd.isExcluded() && !pd.getTo().isExcluded() && !pd.getRefactoringState().hasBeenDeleted();

    private GraphViewRepresentationHandler() {
    }

    public static GraphViewState createState(GraphViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'createState' must not be null";
        GraphViewStateCollector collector = new GraphViewStateCollector();
        representation.accept(collector);
        return collector.getState();
    }

    private static void applyNodesState(GraphViewState state, GraphViewRepresentation representation) {
        GraphViewNode nextNode;
        assert (state != null) : "Parameter 'state' of method 'applyNodesState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyNodesState' must not be null";
        LOGGER.debug("Apply nodes state");
        for (Map.Entry<GraphViewNode, String> nextEntry : state.getExpandedNodes().entrySet()) {
            nextNode = nextEntry.getKey();
            if (!nextNode.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Node is not valid trying to resolve: " + nextEntry.getValue());
                }
                nextNode = GraphViewElementResolver.resolve(nextEntry.getValue(), GraphViewNode.class, representation, false);
            }
            if (nextNode == null || !nextNode.isExpandable() || nextNode.isExpanded()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Expanding node: " + nextNode.getRelativePath());
            }
            GraphViewRepresentationHandler.expand(nextNode);
        }
        for (Map.Entry<GraphViewNode, String> nextEntry : state.getSelectedNodes().entrySet()) {
            nextNode = nextEntry.getKey();
            if (!nextNode.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Node is not valid trying to resolve: " + nextEntry.getValue());
                }
                nextNode = GraphViewElementResolver.resolve(nextEntry.getValue(), GraphViewNode.class, representation, false);
            }
            if (nextNode == null || !nextNode.isVisible()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Selecting node: " + nextNode.getRelativePath());
            }
            nextNode.setSelected(true);
        }
    }

    private static void applyDependenciesState(GraphViewState state, GraphViewRepresentation representation) {
        assert (state != null) : "Parameter 'state' of method 'applyDependenciesState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyDependenciesState' must not be null";
        LOGGER.debug("Apply dependencies state");
        for (Map.Entry<StrictPair<GraphViewNode, GraphViewNode>, GraphViewDependencyDescriptor> nextEntry : state.getSelectedDependencies().entrySet()) {
            GraphViewNode.GraphViewDependency nextDependency;
            GraphViewNode nextFrom = (GraphViewNode)nextEntry.getKey().getFirst();
            GraphViewNode nextTo = (GraphViewNode)nextEntry.getKey().getSecond();
            GraphViewDependencyDescriptor nextDescriptor = nextEntry.getValue();
            if (!nextFrom.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("From node is not valid trying to resolve: " + nextDescriptor.getFrom());
                }
                nextFrom = GraphViewElementResolver.resolve(nextDescriptor.getFrom(), GraphViewNode.class, representation, false);
            }
            if (!nextTo.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("To node is not valid trying to resolve: " + nextDescriptor.getTo());
                }
                nextTo = GraphViewElementResolver.resolve(nextDescriptor.getTo(), GraphViewNode.class, representation, false);
            }
            if (nextFrom == null || nextTo == null || (nextDependency = nextFrom.getOutgoingDependency(nextTo)) == null) continue;
            nextDependency.setSelected(true);
        }
        LOGGER.debug("Apply dependencies state - done");
    }

    public static GraphViewNode applyState(GraphViewState state, String topmostNode, GraphViewRepresentation representation) {
        assert (state != null) : "Parameter 'state' of method 'applyState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyState' must not be null";
        GraphViewResetStateVisitor resetStateVisitor = new GraphViewResetStateVisitor();
        representation.accept(resetStateVisitor);
        resetStateVisitor.getExpanded().forEach(e -> GraphViewRepresentationHandler.collapse(e));
        GraphViewRepresentationHandler.applyNodesState(state, representation);
        GraphViewRepresentationHandler.applyDependenciesState(state, representation);
        if (topmostNode != null && !topmostNode.isEmpty()) {
            return GraphViewElementResolver.resolve(topmostNode, GraphViewNode.class, representation, false);
        }
        return null;
    }

    public static boolean addArchitectureRelatedInfo(GraphViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'addArchitectureRelatedInfo' must not be null";
        DependenciesViewRepresentationInfo representationInfo = representation.getRepresentationInfo();
        boolean hadIssuesOrViolationsOrDeprecations = representationInfo.hasIssuesOrViolationsOrDeprecations();
        GraphViewArchitectureInfoProcessor processor = new GraphViewArchitectureInfoProcessor();
        processor.process(representation.getCurrentModel(), null, GraphViewStructureMode.LOGICAL_NAMESPACE_CYCLE.equals((Object)representation.getStructureMode()), representationInfo);
        if (hadIssuesOrViolationsOrDeprecations != representationInfo.hasIssuesOrViolationsOrDeprecations()) {
            representation.accept(new GraphViewUpdateDependenciesVisitor(representation));
            return true;
        }
        return false;
    }

    public static boolean clearArchitectureRelatedInfo(GraphViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'clearArchitectureRelatedInfo' must not be null";
        return representation.clearDependencyInfo(false);
    }

    public static boolean addSystemDiffRelatedInfo(GraphViewRepresentation representation, ISystemDiffAdditionalInfoProvider provider) {
        Set<NamedElement> added;
        assert (representation != null) : "Parameter 'representation' of method 'addSystemDiffRelatedInfo' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'addSystemDiffRelatedInfo' must not be null";
        List<GraphViewCycleGroupNode> cycleGroupNodes = representation.getChildren(GraphViewCycleGroupNode.class);
        ArrayList<CycleGroup> cycleGroups = new ArrayList<CycleGroup>(cycleGroupNodes.size());
        for (GraphViewCycleGroupNode next : cycleGroupNodes) {
            if (next.getBasedOn() == null) continue;
            cycleGroups.add(next.getBasedOn());
        }
        if (!cycleGroups.isEmpty() && !(added = provider.getAddedCyclicElements(cycleGroups)).isEmpty()) {
            representation.accept(new MarkAddedCyclicElementsVisitor(added));
            return true;
        }
        return false;
    }

    public static boolean clearSystemDiffRelatedInfo(GraphViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'clearSystemDiffRelatedInfo' must not be null";
        LOGGER.debug("Clear system diff related info");
        ResetAddedCyclicElementsVisitor visitor = new ResetAddedCyclicElementsVisitor();
        representation.accept(visitor);
        boolean cleared = visitor.atLeastOneElementReset();
        LOGGER.debug("Clear system diff related info - done [" + cleared + "]");
        return cleared;
    }

    public static void collapse(GraphViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'collapse' must not be null";
        assert (node.isExpanded()) : "Collapse not possible: " + String.valueOf(node);
        GraphViewRepresentation graphViewRepresentation = node.getParent(GraphViewRepresentation.class, ParentMode.FIRST_PARENT);
        assert (graphViewRepresentation != null) : "'graphViewRepresentation' of method 'collapse' must not be null";
        THashSet children = new THashSet(node.getChildren(GraphViewNode.class));
        for (GraphViewNode nextChild : children) {
            nextChild.setSelected(false);
            nextChild.setVisible(false);
        }
        for (GraphViewNode nextChild : children) {
            for (GraphViewNode.GraphViewDependency nextOut : nextChild.getOutgoingDependencies()) {
                GraphViewNode nextTo = nextOut.getTo();
                if (!children.contains(nextTo)) {
                    if (nextTo.isVisible()) {
                        node.addDependendencyTo(nextTo, nextOut.getParserDependencies(), graphViewRepresentation);
                    } else {
                        assert (nextTo.isCyclic()) : "Cyclic 'to' node expected: " + String.valueOf(nextTo);
                        GraphViewCycleGroupNode nextToCycleGroupParent = nextTo.getParent(GraphViewCycleGroupNode.class, ParentMode.ONLY_DIRECT_PARENT);
                        assert (nextToCycleGroupParent != null) : "'nextToCycleGroupParent' of method 'collapse' must not be null";
                        node.addDependendencyTo(nextToCycleGroupParent, nextOut.getParserDependencies(), graphViewRepresentation);
                    }
                }
                nextOut.setVisible(false);
            }
            for (GraphViewNode.GraphViewDependency nextIn : nextChild.getIncomingDependencies()) {
                GraphViewNode nextFrom = nextIn.getFrom();
                if (!children.contains(nextFrom)) {
                    if (nextFrom.isVisible()) {
                        node.addDependendencyFrom(nextFrom, nextIn.getParserDependencies(), graphViewRepresentation);
                    } else {
                        assert (nextFrom.isCyclic()) : "Cyclic 'from' node expected: " + String.valueOf(nextFrom);
                        GraphViewCycleGroupNode nextFromCycleGroupParent = nextFrom.getParent(GraphViewCycleGroupNode.class, ParentMode.ONLY_DIRECT_PARENT);
                        assert (nextFromCycleGroupParent != null) : "'nextFromCycleGroupParent' of method 'collapse' must not be null";
                        node.addDependendencyFrom(nextFromCycleGroupParent, nextIn.getParserDependencies(), graphViewRepresentation);
                    }
                }
                nextIn.setVisible(false);
            }
        }
        node.setExpanded(false);
    }

    public static void expand(GraphViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'expand' must not be null";
        assert (node.isExpandable() && !node.isExpanded()) : "Expand not possible: " + String.valueOf(node);
        GraphViewRepresentation graphViewRepresentation = node.getParent(GraphViewRepresentation.class, ParentMode.FIRST_PARENT);
        assert (graphViewRepresentation != null) : "'graphViewRepresentation' of method 'expand' must not be null";
        node.removeDependencies();
        node.getChildren(GraphViewNode.class).forEach(c -> c.setVisible(true));
        for (GraphViewNode nextChild : node.getChildren(GraphViewNode.class)) {
            for (GraphViewNode.GraphViewDependency nextOut : nextChild.getOutgoingDependencies()) {
                GraphViewNode nextTo = nextOut.getTo();
                if (nextTo.isVisible()) {
                    nextOut.setVisible(true);
                    continue;
                }
                assert (nextTo.isCyclic()) : "Cyclic 'to' node expected in 'expand': " + String.valueOf(nextTo);
                GraphViewCycleGroupNode nextToCycleGroupParent = nextTo.getParent(GraphViewCycleGroupNode.class, ParentMode.ONLY_DIRECT_PARENT);
                assert (nextToCycleGroupParent != null) : "'nextToCycleGroupParent' of method 'expand' must not be null";
                nextChild.addDependendencyTo(nextToCycleGroupParent, nextOut.getParserDependencies(), graphViewRepresentation);
            }
            for (GraphViewNode.GraphViewDependency nextIn : nextChild.getIncomingDependencies()) {
                GraphViewNode nextFrom = nextIn.getFrom();
                if (nextFrom.isVisible()) {
                    nextIn.setVisible(true);
                    continue;
                }
                assert (nextFrom.isCyclic()) : "Cyclic 'from' node expected in 'expand': " + String.valueOf(nextFrom);
                GraphViewCycleGroupNode nextFromCycleGroupParent = nextFrom.getParent(GraphViewCycleGroupNode.class, ParentMode.ONLY_DIRECT_PARENT);
                assert (nextFromCycleGroupParent != null) : "'nextFromCycleGroupParent' of method 'expand' must not be null";
                nextChild.addDependendencyTo(nextFromCycleGroupParent, nextIn.getParserDependencies(), graphViewRepresentation);
            }
        }
        node.setExpanded(true);
    }

    private static Collection<GraphViewCycleGroupNode> create(IWorkerContext workerContext, GraphViewRepresentation representation, DependencyEndpointCollector collector, Set<NamedElement> elements, Set<AnalyzerCycleGroup> basedOnCycleGroups, ISystemDiffAdditionalInfoProvider provider) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'create' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'create' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'create' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'create' must not be empty";
        assert (provider != null) : "Parameter 'provider' of method 'create' must not be null";
        LOGGER.debug("Create graph view representation");
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet(workerContext, elements, collector, PE, PD);
        CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
        CycleAnalyzer.compute(cycleAnalyzerAdapter, workerContext);
        ArrayList sortedNodeAdapters = new ArrayList(nodeAdapterSet.getNodes());
        Collections.sort(sortedNodeAdapters, new Comparator<ParserDependencyNodeAdapter>(){

            @Override
            public int compare(ParserDependencyNodeAdapter n1, ParserDependencyNodeAdapter n2) {
                if (!$assertionsDisabled && n1 == null) {
                    throw new AssertionError((Object)"Parameter 'n1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && n2 == null) {
                    throw new AssertionError((Object)"Parameter 'n2' of method 'compare' must not be null");
                }
                int compared = n2.getLevel() - n1.getLevel();
                if (compared == 0) {
                    compared = n1.getUnderlyingObject().getFullyQualifiedName().compareTo(n2.getUnderlyingObject().getFullyQualifiedName());
                }
                return compared;
            }
        });
        THashMap nodeAdapterToViewNode = new THashMap();
        THashMap indexToCycleViewNode = new THashMap();
        for (ParserDependencyNodeAdapter next : sortedNodeAdapters) {
            GraphViewNodeWithUnderlyingElement nextNode;
            int nextLevel = next.getLevel();
            if (cycleAnalyzerAdapter.isCyclic(next)) {
                Integer nextGroupIndex = cycleAnalyzerAdapter.getGroupIndex(next);
                GraphViewCycleGroupNode nextCycleGroupNode = (GraphViewCycleGroupNode)indexToCycleViewNode.get(nextGroupIndex);
                if (nextCycleGroupNode == null) {
                    nextCycleGroupNode = new GraphViewCycleGroupNode(representation, nextLevel, nextGroupIndex);
                    nextCycleGroupNode.setIsExpandable(true);
                    nextCycleGroupNode.setExpanded(true);
                    representation.addChild(nextCycleGroupNode);
                    indexToCycleViewNode.put(nextGroupIndex, nextCycleGroupNode);
                    if (basedOnCycleGroups != null) {
                        block1: for (AnalyzerCycleGroup nextAnalyzerCycleGroup : basedOnCycleGroups) {
                            for (NamedElement nextCyclic : nextAnalyzerCycleGroup.getCyclicNamedElements()) {
                                if (next.getUnderlyingObject() != nextCyclic) continue;
                                nextCycleGroupNode.setBasedOn(nextAnalyzerCycleGroup);
                                break block1;
                            }
                        }
                    }
                }
                nextNode = new GraphViewCyclicNode(nextCycleGroupNode, nextLevel, next.getUnderlyingObject());
                nextCycleGroupNode.addChild(nextNode);
            } else {
                nextNode = new GraphViewNonCyclicNode(representation, nextLevel, next.getUnderlyingObject());
                representation.addChild(nextNode);
            }
            nodeAdapterToViewNode.put(next, nextNode);
        }
        for (ParserDependencyNodeAdapter nextNodeAdapter : nodeAdapterSet.getNodes()) {
            for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> nextOut : nextNodeAdapter.getOutgoingEdges()) {
                GraphViewNode nextFrom = (GraphViewNode)nodeAdapterToViewNode.get(nextOut.getFrom());
                assert (nextFrom != null) : "'nextFrom' of method 'createGraphViewRepresentation' must not be null";
                GraphViewNode nextTo = (GraphViewNode)nodeAdapterToViewNode.get(nextOut.getTo());
                assert (nextTo != null) : "'nextTo' of method 'createGraphViewRepresentation' must not be null";
                nextFrom.addDependendencyTo(nextTo, nextOut.getDependencies(), representation);
            }
        }
        GraphViewRepresentationHandler.addArchitectureRelatedInfo(representation);
        if (provider.isSoftwareSystemDiffAvailable()) {
            GraphViewRepresentationHandler.addSystemDiffRelatedInfo(representation, provider);
        }
        THashSet basedOnNamedElements = new THashSet(elements.size());
        elements.forEach(arg_0 -> GraphViewRepresentationHandler.lambda$4((Set)basedOnNamedElements, arg_0));
        representation.finishCreation((Set<String>)basedOnNamedElements);
        LOGGER.debug("Create graph view representation - done");
        return indexToCycleViewNode.values();
    }

    public static GraphViewRepresentation create(IWorkerContext workerContext, ISystemDiffAdditionalInfoProvider provider, NamedElement parent, Set<NamedElement> elements, Set<AnalyzerCycleGroup> basedOnCycleGroups, boolean cyclesAreExpandable, boolean expandCycles) {
        GraphViewRepresentation representation;
        block35: {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'create' must not be null";
            assert (provider != null) : "Parameter 'provider' of method 'create' must not be null";
            assert (parent != null) : "Parameter 'parent' of method 'create' must not be null";
            assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'create' must not be empty";
            assert (basedOnCycleGroups != null && !basedOnCycleGroups.isEmpty()) : "Parameter 'basedOnCycleGroups' of method 'create' must not be empty";
            assert (parent.getUniqueChild(GraphViewRepresentation.class) == null) : "Representation of method 'create' must already created";
            assert (cyclesAreExpandable || !expandCycles) : "Cycles cannot be expanded when cycles are not expandable";
            IAnalyzerId analyzerId = null;
            IIssueId issuedId = null;
            for (AnalyzerCycleGroup nextCycleGroup : basedOnCycleGroups) {
                IAnalyzer nextAnalyzer = nextCycleGroup.getParent(IAnalyzer.class, ParentMode.FIRST_PARENT);
                assert (nextAnalyzer != null) : "'nextAnalyzer' of method 'getCollector' must not be null";
                if (analyzerId == null) {
                    analyzerId = nextAnalyzer.getId();
                } else assert (analyzerId.equals(nextAnalyzer.getId())) : "Different cycle group analyzer id: " + String.valueOf(analyzerId) + "/" + String.valueOf(nextAnalyzer.getId());
                IIssueId nextId = nextCycleGroup.getCycleGroupIssueId();
                if (issuedId == null) {
                    issuedId = nextId;
                    continue;
                }
                assert (issuedId.equals(nextId)) : "Different cycle group issues: " + String.valueOf(issuedId) + "/" + String.valueOf(nextId);
            }
            GraphViewStructureMode structureMode = null;
            DependencyEndpointCollector collector = null;
            if (CoreIssueId.MODULE_CYCLE_GROUP.equals(issuedId)) {
                structureMode = GraphViewStructureMode.PHYSICAL_MODULE_CYCLE;
                collector = new DependencyEndpointCollector();
            } else if (CoreIssueId.DIRECTORY_CYCLE_GROUP.equals(issuedId)) {
                DirectoryDependencyEndpointCollector directoryCollector = new DirectoryDependencyEndpointCollector();
                for (NamedElement next : elements) {
                    assert (next != null && next instanceof IDirectoryPath) : "Unexpected class in method 'getCollector': " + String.valueOf(next);
                    directoryCollector.addDirectory((IDirectoryPath)((Object)next));
                }
                structureMode = GraphViewStructureMode.PHYSICAL_DIRECTORY_CYCLE;
                collector = directoryCollector;
            } else if (CoreIssueId.COMPONENT_CYCLE_GROUP.equals(issuedId)) {
                structureMode = GraphViewStructureMode.PHYSICAL_COMPONENT_CYCLE;
                collector = new DependencyEndpointCollector();
            } else if (CoreIssueId.LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUP.equals(issuedId)) {
                structureMode = GraphViewStructureMode.LOGICAL_TOPLEVEL_PROGRAMMING_ELEMENT_CYCLE;
                LogicalProgrammingElementDependencyEndpointCollector lpeCollector = new LogicalProgrammingElementDependencyEndpointCollector();
                ArrayList<LogicalProgrammingElement> lpes = new ArrayList<LogicalProgrammingElement>(elements.size());
                for (NamedElement next : elements) {
                    assert (next != null && next instanceof LogicalProgrammingElement) : "Unexpected class in method 'getCollector': " + String.valueOf(next);
                    lpes.add((LogicalProgrammingElement)next);
                }
                lpeCollector.addLogicalProgrammingElements(lpes);
                collector = lpeCollector;
            } else if (CoreIssueId.NAMESPACE_CYCLE_GROUP.equals(issuedId)) {
                LogicalNamespaceDependencyEndpointCollector namespaceCollector = new LogicalNamespaceDependencyEndpointCollector();
                ArrayList<LogicalNamespace> ln = new ArrayList<LogicalNamespace>(elements.size());
                for (NamedElement next : elements) {
                    assert (next != null && next instanceof LogicalNamespace) : "Unexpected class in method 'getCollector': " + String.valueOf(next);
                    ln.add((LogicalNamespace)next);
                }
                namespaceCollector.addLogicalNamespaces(ln);
                structureMode = GraphViewStructureMode.LOGICAL_NAMESPACE_CYCLE;
                collector = namespaceCollector;
            } else assert (false) : "Unhandled issue id: " + String.valueOf(issuedId);
            representation = new GraphViewRepresentation(structureMode, analyzerId, cyclesAreExpandable);
            representation.setParent(parent);
            parent.addChild(representation);
            Collection<GraphViewCycleGroupNode> cycleGroupNodes = GraphViewRepresentationHandler.create(workerContext, representation, collector, elements, basedOnCycleGroups, provider);
            if (cycleGroupNodes.isEmpty()) break block35;
            if (!expandCycles) {
                for (GraphViewCycleGroupNode nextCycleGroupNode : cycleGroupNodes) {
                    GraphViewRepresentationHandler.collapse(nextCycleGroupNode);
                    nextCycleGroupNode.setIsExpandable(representation.cyclesAreExpandable());
                }
            } else {
                for (GraphViewCycleGroupNode nextCycleGroupNode : cycleGroupNodes) {
                    nextCycleGroupNode.setIsExpandable(representation.cyclesAreExpandable());
                }
            }
        }
        return representation;
    }

    public static void recreate(IWorkerContext workerContext, ISystemDiffAdditionalInfoProvider infoProvider, Set<NamedElement> elements, Set<AnalyzerCycleGroup> basedOnCycleGroups, GraphViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'recreate' must not be null";
        assert (infoProvider != null) : "Parameter 'infoProvider' of method 'recreate' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'recreate' must not be empty";
        assert (basedOnCycleGroups != null) : "Parameter 'basedOnCycleGroups' of method 'recreate' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'recreate' must not be null";
        DependencyEndpointCollector collector = switch (representation.getStructureMode()) {
            case GraphViewStructureMode.PHYSICAL_MODULE_CYCLE -> new DependencyEndpointCollector();
            case GraphViewStructureMode.PHYSICAL_DIRECTORY_CYCLE -> {
                DirectoryDependencyEndpointCollector directoryCollector = new DirectoryDependencyEndpointCollector();
                for (NamedElement next : elements) {
                    if (!($assertionsDisabled || next != null && next instanceof IDirectoryPath)) {
                        throw new AssertionError((Object)("Unexpected class in method 'getCollector': " + String.valueOf(next)));
                    }
                    directoryCollector.addDirectory((IDirectoryPath)((Object)next));
                }
                yield directoryCollector;
            }
            case GraphViewStructureMode.PHYSICAL_COMPONENT_CYCLE -> new DependencyEndpointCollector();
            case GraphViewStructureMode.LOGICAL_NAMESPACE_CYCLE -> {
                LogicalNamespaceDependencyEndpointCollector namespaceCollector = new LogicalNamespaceDependencyEndpointCollector();
                ArrayList<LogicalNamespace> ln = new ArrayList<LogicalNamespace>(elements.size());
                for (NamedElement next : elements) {
                    if (!($assertionsDisabled || next != null && next instanceof LogicalNamespace)) {
                        throw new AssertionError((Object)("Unexpected class in method 'getCollector': " + String.valueOf(next)));
                    }
                    ln.add((LogicalNamespace)next);
                }
                namespaceCollector.addLogicalNamespaces(ln);
                yield namespaceCollector;
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled structure mode: " + String.valueOf((Object)representation.getStructureMode())));
                }
                yield null;
            }
        };
        GraphViewState state = GraphViewRepresentationHandler.createState(representation);
        representation.reset();
        GraphViewRepresentationHandler.create((IWorkerContext)DefaultWorkerContext.INSTANCE, representation, collector, elements, basedOnCycleGroups, infoProvider);
        GraphViewRepresentationHandler.applyNodesState(state, representation);
        GraphViewRepresentationHandler.applyDependenciesState(state, representation);
    }

    public static List<NamedElement> getNamedElements(GraphViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'getNamedElements' must not be null";
        ArrayList<NamedElement> collector = new ArrayList<NamedElement>();
        UnderlyingNamedElementCollector underlyingNamedElementCollector = new UnderlyingNamedElementCollector(collector);
        representation.accept(underlyingNamedElementCollector);
        return collector;
    }

    private static /* synthetic */ void lambda$4(Set set, NamedElement e) {
        boolean bl = set.add(e.getFullyQualifiedName());
    }
}

