/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.explorationview.ITargetArchitectureFileValidator;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;

public final class TargetArchitectureFileValidator
implements ITargetArchitectureFileValidator {
    private final TFile m_directory;

    public TargetArchitectureFileValidator(TFile directory) {
        assert (directory != null) : "Parameter 'directory' of method 'TargetArchitectureFileValidator' must not be null";
        this.m_directory = directory;
    }

    @Override
    public TFile getDirectory() {
        return this.m_directory;
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(StringUtility.areEqual((String)currentInput, (String)newInput));
        String string = newInput = newInput != null ? newInput.trim() : null;
        if (newInput == null || newInput.isEmpty()) {
            result.addError("Must not be empty");
        } else if (!FileUtility.isValidName((String)newInput)) {
            result.addError("Not a valid file name.");
        } else {
            String[] stringArray = CoreFileType.ARCHITECTURE.getExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nextExtension = stringArray[n2];
                boolean valid = true;
                if (newInput.endsWith(nextExtension)) {
                    result.addError("Extension will be added automatically.");
                    valid = false;
                    break;
                }
                if (valid) {
                    String fileName = newInput + CoreFileType.ARCHITECTURE.getDefaultExtension();
                    TFile[] files = this.m_directory.listFiles();
                    if (files != null) {
                        TFile[] tFileArray = files;
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TFile nextFile = tFileArray[n4];
                            if (!nextFile.isDirectory() && FileUtility.refersToSameFileName((String)nextFile.getName(), (String)fileName)) {
                                result.addWarning("The directory already contains a file named '" + fileName + "'");
                                break;
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return result;
    }
}

