/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepresentationPrinter
extends ArchitecturalViewVisitor
implements ArchitecturalViewNode.IVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationPrinter.class);
    private final PrintStream m_stream;

    private RepresentationPrinter(PrintStream stream) {
        assert (stream != null) : "Parameter 'stream' of method 'RepresentationPrinter' must not be null";
        this.m_stream = stream;
    }

    @Override
    public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        if (element.isVisible()) {
            int depth = element.getDepth();
            int i = 0;
            while (i < depth) {
                this.m_stream.print("+");
                ++i;
            }
            this.m_stream.println(element.getElementInfo());
            if (element.isExpanded()) {
                this.visitChildrenOf(element);
            }
        }
    }

    public static void print(ExplorationViewRepresentation representation, final StringBuilder builder) {
        assert (representation != null) : "Parameter 'representation' of method 'print' must not be null";
        assert (builder != null) : "Parameter 'builder' of method 'print' must not be null";
        representation.accept(new RepresentationPrinter(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                builder.append((char)b);
            }
        }, true)));
    }

    public static void print(ExplorationViewRepresentation representation, String context) {
        assert (representation != null) : "Parameter 'representation' of method 'print' must not be null";
        assert (context != null && context.length() > 0) : "Parameter 'context' of method 'print' must not be empty";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Start representation '" + context + "' ###");
            representation.accept(new RepresentationPrinter(System.out));
            LOGGER.debug("### End representation '" + context + "' ###");
        }
    }
}

